/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.persistence.postgresql.reporting.database.sqlbuilders;

import java.util.List;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.kie.kogito.persistence.postgresql.reporting.database.sqlbuilders.PostgresContext;
import org.kie.kogito.persistence.postgresql.reporting.model.JsonType;
import org.kie.kogito.persistence.postgresql.reporting.model.PostgresField;
import org.kie.kogito.persistence.postgresql.reporting.model.PostgresMapping;
import org.kie.kogito.persistence.postgresql.reporting.model.PostgresPartitionField;
import org.kie.kogito.persistence.reporting.model.paths.PathSegment;

class PostgresContextTest {
    PostgresContextTest() {
    }

    @Test
    void testPostgresContext() {
        PostgresField field = new PostgresField("field1", JsonType.STRING);
        PostgresPartitionField partitionField = new PostgresPartitionField("partitionField1", JsonType.STRING, "value");
        PostgresMapping mapping = new PostgresMapping("sourceJsonPath", new PostgresField("targetField1", JsonType.STRING));
        PathSegment pathSegment = new PathSegment("segment", null);
        PostgresContext context = new PostgresContext("mappingId", "sourceTableName", "sourceTableJsonFieldName", List.of(field), List.of(partitionField), "targetTableName", List.of(mapping), List.of(pathSegment));
        Assertions.assertEquals((Object)"mappingId", (Object)context.getMappingId());
        Assertions.assertEquals((Object)"sourceTableName", (Object)context.getSourceTableName());
        Assertions.assertEquals((Object)"sourceTableJsonFieldName", (Object)context.getSourceTableJsonFieldName());
        Assertions.assertEquals(List.of(field), (Object)context.getSourceTableIdentityFields());
        Assertions.assertEquals(List.of(partitionField), (Object)context.getSourceTablePartitionFields());
        Assertions.assertEquals((Object)"targetTableName", (Object)context.getTargetTableName());
        Assertions.assertEquals(List.of(mapping), (Object)context.getFieldMappings());
        Assertions.assertEquals(List.of(pathSegment), (Object)context.getMappingPaths());
    }
}

