/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.persistence.postgresql.reporting.database.sqlbuilders;

import java.util.List;
import java.util.Objects;
import javax.persistence.EntityManager;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.kie.kogito.persistence.postgresql.reporting.database.BasePostgresDatabaseManagerImpl;
import org.kie.kogito.persistence.postgresql.reporting.database.sqlbuilders.PostgresApplyMappingSqlBuilder;
import org.kie.kogito.persistence.postgresql.reporting.database.sqlbuilders.PostgresContext;
import org.kie.kogito.persistence.postgresql.reporting.database.sqlbuilders.PostgresIndexesSqlBuilder;
import org.kie.kogito.persistence.postgresql.reporting.database.sqlbuilders.PostgresTableSqlBuilder;
import org.kie.kogito.persistence.postgresql.reporting.database.sqlbuilders.PostgresTriggerDeleteSqlBuilder;
import org.kie.kogito.persistence.postgresql.reporting.database.sqlbuilders.PostgresTriggerInsertSqlBuilder;
import org.kie.kogito.persistence.postgresql.reporting.model.JsonType;
import org.kie.kogito.persistence.postgresql.reporting.model.PostgresField;
import org.kie.kogito.persistence.postgresql.reporting.model.PostgresMapping;
import org.kie.kogito.persistence.postgresql.reporting.model.PostgresMappingDefinition;
import org.kie.kogito.persistence.postgresql.reporting.model.PostgresPartitionField;
import org.mockito.Mock;
import org.mockito.junit.jupiter.MockitoExtension;

@ExtendWith(value={MockitoExtension.class})
abstract class BaseSqlBuilderImplTest {
    protected static final PostgresMappingDefinition DEFINITION = new PostgresMappingDefinition("mappingId", "sourceTableName", "sourceTableJsonFieldName", List.of(new PostgresField("id", JsonType.STRING), new PostgresField("key", JsonType.STRING)), List.of(new PostgresPartitionField("partition", JsonType.STRING, "chunk"), new PostgresPartitionField("partition2", JsonType.STRING, "chunk2")), "targetTableName", List.of(new PostgresMapping("root", new PostgresField("field1", JsonType.STRING)), new PostgresMapping("root.child", new PostgresField("field2", JsonType.STRING)), new PostgresMapping("root.child.collection[].child", new PostgresField("field3", JsonType.STRING)), new PostgresMapping("root.child.sibling", new PostgresField("field4", JsonType.STRING))));
    @Mock
    private EntityManager entityManager;
    @Mock
    private PostgresIndexesSqlBuilder mockIndexesSqlBuilder;
    @Mock
    private PostgresTableSqlBuilder mockTableSqlBuilder;
    @Mock
    private PostgresTriggerDeleteSqlBuilder mockTriggerDeleteSqlBuilder;
    @Mock
    private PostgresTriggerInsertSqlBuilder mockTriggerInsertSqlBuilder;
    @Mock
    private PostgresApplyMappingSqlBuilder mockApplyMappingSqlBuilder;
    protected BasePostgresDatabaseManagerImpl manager;

    BaseSqlBuilderImplTest() {
    }

    @BeforeEach
    void setup() {
        this.manager = new BasePostgresDatabaseManagerImpl(this.getIndexesBuilder(), this.getTableBuilder(), this.getTriggerDeleteBuilder(), this.getTriggerInsertBuilder(), this.getApplyMappingSqlBuilder()){

            protected EntityManager getEntityManager(String sourceTableName) {
                return BaseSqlBuilderImplTest.this.entityManager;
            }
        };
    }

    protected PostgresIndexesSqlBuilder getIndexesBuilder() {
        return this.mockIndexesSqlBuilder;
    }

    protected PostgresTableSqlBuilder getTableBuilder() {
        return this.mockTableSqlBuilder;
    }

    protected PostgresTriggerDeleteSqlBuilder getTriggerDeleteBuilder() {
        return this.mockTriggerDeleteSqlBuilder;
    }

    protected PostgresTriggerInsertSqlBuilder getTriggerInsertBuilder() {
        return this.mockTriggerInsertSqlBuilder;
    }

    protected PostgresApplyMappingSqlBuilder getApplyMappingSqlBuilder() {
        return this.mockApplyMappingSqlBuilder;
    }

    protected abstract String getCreateSql(PostgresContext var1);

    protected abstract String getDestroySql(PostgresContext var1);

    protected abstract void assertCreateSql(String var1);

    protected abstract void assertDestroySql(String var1);

    @Test
    void testCreate() {
        PostgresContext context = this.manager.createContext(DEFINITION);
        String sql = this.getCreateSql(context);
        this.assertCreateSql(sql);
    }

    @Test
    void testDestroy() {
        PostgresContext context = this.manager.createContext(DEFINITION);
        String sql = this.getDestroySql(context);
        this.assertDestroySql(sql);
    }

    protected void assertSequentialContent(String actual, String ... expected) {
        if (Objects.isNull(expected)) {
            return;
        }
        if (expected.length == 0) {
            return;
        }
        int idx = 0;
        for (String line : expected) {
            Assertions.assertTrue(((idx = actual.indexOf(line, idx)) > -1 ? 1 : 0) != 0, (String)String.format("Line '%s' not found in '%s'", line, actual));
        }
    }
}

