/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.persistence.postgresql.reporting.database;

import java.util.List;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.kie.kogito.persistence.postgresql.reporting.model.JsonType;
import org.kie.kogito.persistence.postgresql.reporting.model.PostgresField;
import org.kie.kogito.persistence.postgresql.reporting.model.PostgresMapping;
import org.kie.kogito.persistence.postgresql.reporting.model.PostgresPartitionField;
import org.kie.kogito.persistence.reporting.database.Validations;

class PostgresValidationsTest {
    PostgresValidationsTest() {
    }

    @Test
    void testValidateSourceTableIdentityFieldsBlankFieldName() {
        PostgresField field = new PostgresField("", JsonType.STRING);
        List<PostgresField> fields = List.of(field);
        Assertions.assertThrows(IllegalArgumentException.class, () -> Validations.validateSourceTableIdentityFields((List)fields));
    }

    @Test
    void testValidateSourceTablePartitionFieldsBlankFieldName() {
        PostgresPartitionField field = new PostgresPartitionField("", JsonType.STRING, "value");
        List<PostgresPartitionField> fields = List.of(field);
        Assertions.assertThrows(IllegalArgumentException.class, () -> Validations.validateSourceTablePartitionFields((List)fields));
    }

    @Test
    void testValidateSourceTablePartitionFieldsBlankFieldValue() {
        PostgresPartitionField field = new PostgresPartitionField("field", JsonType.STRING, "");
        List<PostgresPartitionField> fields = List.of(field);
        Assertions.assertThrows(IllegalArgumentException.class, () -> Validations.validateSourceTablePartitionFields((List)fields));
    }

    @Test
    void testValidateTargetTableFieldsBlankSourceJsonPath() {
        PostgresMapping mapping = new PostgresMapping("", new PostgresField("field", JsonType.STRING));
        List<PostgresMapping> mappings = List.of(mapping);
        Assertions.assertThrows(IllegalArgumentException.class, () -> Validations.validateFieldMappings((List)mappings));
    }
}

