/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.persistence.postgresql.reporting.bootstrap;

import io.quarkus.runtime.StartupEvent;
import java.util.List;
import java.util.Optional;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.kie.kogito.persistence.postgresql.reporting.bootstrap.PostgresBootstrapLoaderImpl;
import org.kie.kogito.persistence.postgresql.reporting.bootstrap.PostgresStartupHandlerImpl;
import org.kie.kogito.persistence.postgresql.reporting.database.BasePostgresDatabaseManagerImpl;
import org.kie.kogito.persistence.postgresql.reporting.model.JsonType;
import org.kie.kogito.persistence.postgresql.reporting.model.PostgresField;
import org.kie.kogito.persistence.postgresql.reporting.model.PostgresMapping;
import org.kie.kogito.persistence.postgresql.reporting.model.PostgresMappingDefinition;
import org.kie.kogito.persistence.postgresql.reporting.model.PostgresMappingDefinitions;
import org.kie.kogito.persistence.postgresql.reporting.model.PostgresPartitionField;
import org.kie.kogito.persistence.postgresql.reporting.service.PostgresMappingServiceImpl;
import org.kie.kogito.persistence.reporting.database.SchemaGenerationAction;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;

@ExtendWith(value={MockitoExtension.class})
class PostgresStartupHandlerImplTest {
    @Mock
    private PostgresBootstrapLoaderImpl loader;
    @Mock
    private BasePostgresDatabaseManagerImpl databaseManager;
    @Mock
    private PostgresMappingServiceImpl mappingService;
    private PostgresStartupHandlerImpl service;

    PostgresStartupHandlerImplTest() {
    }

    @BeforeEach
    public void setup() {
        this.service = new PostgresStartupHandlerImpl(this.loader, this.databaseManager, this.mappingService, SchemaGenerationAction.DROP_AND_CREATE.getActionString());
    }

    @Test
    void testOnStart() {
        PostgresMappingDefinition definition = new PostgresMappingDefinition("mappingId", "sourceTableName", "sourceTableJsonFieldName", List.of(new PostgresField("key", JsonType.STRING)), List.of(new PostgresPartitionField("sourceTablePartitionFieldName", JsonType.STRING, "sourceTablePartitionName")), "targetTableName", List.of(new PostgresMapping("sourceJsonPath", new PostgresField("targetFieldName", JsonType.STRING))));
        PostgresMappingDefinitions definitions = new PostgresMappingDefinitions(List.of(definition));
        Mockito.when((Object)this.loader.load()).thenReturn(Optional.of(definitions));
        this.service.onStartup(new StartupEvent());
        ((PostgresMappingServiceImpl)Mockito.verify((Object)this.mappingService)).saveMappingDefinition(definition);
        ((BasePostgresDatabaseManagerImpl)Mockito.verify((Object)this.databaseManager)).createArtifacts(definition);
    }
}

