/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.persistence.postgresql.reporting.bootstrap;

import com.fasterxml.jackson.core.JsonProcessingException;
import java.io.ByteArrayInputStream;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Optional;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.kie.kogito.event.cloudevents.utils.CloudEventUtils;
import org.kie.kogito.persistence.postgresql.reporting.bootstrap.PostgresBootstrapLoaderImpl;
import org.kie.kogito.persistence.postgresql.reporting.model.JsonType;
import org.kie.kogito.persistence.postgresql.reporting.model.PostgresField;
import org.kie.kogito.persistence.postgresql.reporting.model.PostgresMapping;
import org.kie.kogito.persistence.postgresql.reporting.model.PostgresMappingDefinition;
import org.kie.kogito.persistence.postgresql.reporting.model.PostgresMappingDefinitions;
import org.kie.kogito.persistence.postgresql.reporting.model.PostgresPartitionField;

class PostgresBootstrapLoaderImplTest {
    PostgresBootstrapLoaderImplTest() {
    }

    @Test
    void testLoadWithResource() throws JsonProcessingException {
        PostgresMappingDefinition definition = new PostgresMappingDefinition("mappingId", "sourceTableName", "sourceTableJsonFieldName", List.of(new PostgresField("key", JsonType.STRING)), List.of(new PostgresPartitionField("sourceTablePartitionFieldName", JsonType.STRING, "sourceTablePartitionName")), "targetTableName", List.of(new PostgresMapping("sourceJsonPath", new PostgresField("targetFieldName", JsonType.STRING))));
        PostgresMappingDefinitions definitions = new PostgresMappingDefinitions(List.of(definition));
        String json = CloudEventUtils.Mapper.mapper().writeValueAsString((Object)definitions);
        ByteArrayInputStream is = new ByteArrayInputStream(json.getBytes(StandardCharsets.UTF_8));
        PostgresBootstrapLoaderImpl loader = new PostgresBootstrapLoaderImpl(() -> is);
        Optional result = loader.load();
        Assertions.assertNotNull((Object)result);
        Assertions.assertTrue((boolean)result.isPresent());
        Assertions.assertEquals((int)1, (int)((PostgresMappingDefinitions)result.get()).getMappingDefinitions().size());
        PostgresMappingDefinition resultDefinition = (PostgresMappingDefinition)((PostgresMappingDefinitions)result.get()).getMappingDefinitions().iterator().next();
        Assertions.assertEquals((Object)definition, (Object)resultDefinition);
    }

    @Test
    void testLoadWithoutResource() {
        ByteArrayInputStream is = new ByteArrayInputStream("".getBytes(StandardCharsets.UTF_8));
        PostgresBootstrapLoaderImpl loader = new PostgresBootstrapLoaderImpl(() -> is);
        Optional result = loader.load();
        Assertions.assertNotNull((Object)result);
        Assertions.assertTrue((boolean)result.isEmpty());
    }
}

