/*
 * Copyright 2022 Red Hat, Inc. and/or its affiliates.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *       http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.kie.kogito.persistence.postgresql.reporting.bootstrap;

import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Observes;
import javax.inject.Inject;

import org.eclipse.microprofile.config.inject.ConfigProperty;
import org.kie.kogito.persistence.postgresql.reporting.database.BasePostgresDatabaseManagerImpl;
import org.kie.kogito.persistence.postgresql.reporting.database.sqlbuilders.PostgresContext;
import org.kie.kogito.persistence.postgresql.reporting.model.JsonType;
import org.kie.kogito.persistence.postgresql.reporting.model.PostgresField;
import org.kie.kogito.persistence.postgresql.reporting.model.PostgresMapping;
import org.kie.kogito.persistence.postgresql.reporting.model.PostgresMappingDefinition;
import org.kie.kogito.persistence.postgresql.reporting.model.PostgresMappingDefinitions;
import org.kie.kogito.persistence.postgresql.reporting.model.PostgresPartitionField;
import org.kie.kogito.persistence.postgresql.reporting.service.PostgresMappingServiceImpl;
import org.kie.kogito.persistence.reporting.bootstrap.BaseStartupHandler;
import org.kie.kogito.persistence.reporting.database.SchemaGenerationAction;

import io.quarkus.runtime.StartupEvent;

@ApplicationScoped
public class PostgresStartupHandlerImpl
        extends BaseStartupHandler<JsonType, PostgresField, PostgresPartitionField, PostgresMapping, PostgresMappingDefinition, PostgresMappingDefinitions, PostgresContext> {

    protected PostgresStartupHandlerImpl() {
        //CDI proxy
    }

    @Inject
    public PostgresStartupHandlerImpl(final PostgresBootstrapLoaderImpl loader,
            final BasePostgresDatabaseManagerImpl databaseManager,
            final PostgresMappingServiceImpl mappingService,
            final @ConfigProperty(name = "quarkus.hibernate-orm.database.generation") String action) {
        super(loader,
                databaseManager,
                mappingService,
                SchemaGenerationAction.fromString(action));
    }

    void onStartup(final @Observes StartupEvent event) {
        super.onStartup();
    }
}
