/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.serverless.workflow.executor;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import io.serverlessworkflow.api.Workflow;
import java.util.Collections;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.kie.kogito.serverless.workflow.executor.StaticWorkflowApplication;
import org.kie.kogito.serverless.workflow.fluent.ActionBuilder;
import org.kie.kogito.serverless.workflow.fluent.FunctionBuilder;
import org.kie.kogito.serverless.workflow.fluent.StateBuilder;
import org.kie.kogito.serverless.workflow.fluent.WorkflowBuilder;

public class PythonFluentWorkflowApplicationTest {
    @Test
    void testPythonNoArgs() {
        try (StaticWorkflowApplication application = StaticWorkflowApplication.create();){
            Workflow workflow = ((WorkflowBuilder)WorkflowBuilder.workflow((String)"PythonTest").start(StateBuilder.operation().action(ActionBuilder.script((String)"x='pepe'", (ActionBuilder.ScriptType)ActionBuilder.ScriptType.PYTHON)).outputFilter("{result:$WORKFLOW.python.x}")).end()).build();
            Assertions.assertThat((String)application.execute(workflow, Collections.emptyMap()).getWorkflowdata().get("result").asText()).isEqualTo("pepe");
        }
    }

    @Test
    void testPythonWithArgs() {
        try (StaticWorkflowApplication application = StaticWorkflowApplication.create();){
            Workflow workflow = ((WorkflowBuilder)WorkflowBuilder.workflow((String)"PythonTest").start(StateBuilder.operation().action(ActionBuilder.script((String)"x*=2", (ActionBuilder.ScriptType)ActionBuilder.ScriptType.PYTHON, (ObjectNode)WorkflowBuilder.jsonObject().put("x", ".x"))).outputFilter("{result:$WORKFLOW.python.x}")).end()).build();
            Assertions.assertThat((int)application.execute(workflow, Map.of("x", 2)).getWorkflowdata().get("result").asInt()).isEqualTo(4);
        }
    }

    @Test
    void testPythonService() {
        try (StaticWorkflowApplication application = StaticWorkflowApplication.create();){
            Workflow workflow = ((WorkflowBuilder)WorkflowBuilder.workflow((String)"Factorial").start((StateBuilder)StateBuilder.operation().action(ActionBuilder.call((FunctionBuilder)FunctionBuilder.python((String)"factorial", (String)"math", (String)"factorial"), (JsonNode)new TextNode(".x")).outputFilter(".result"))).end()).build();
            Assertions.assertThat((int)application.execute(workflow, Map.of("x", 5)).getWorkflowdata().get("result").asInt()).isEqualTo(120);
        }
    }

    @Test
    void testNotStandardPythonService() {
        try (StaticWorkflowApplication application = StaticWorkflowApplication.create(Map.of("org.sonataflow.python.searchpath", "./src/test/resources/"));){
            Workflow workflow = ((WorkflowBuilder)WorkflowBuilder.workflow((String)"Factorial").start((StateBuilder)StateBuilder.operation().action(ActionBuilder.call((FunctionBuilder)FunctionBuilder.python((String)"factorial", (String)"custom", (String)"factorial"), (JsonNode)new TextNode(".x")).outputFilter(".result"))).end()).build();
            Assertions.assertThat((int)application.execute(workflow, Map.of("x", 5)).getWorkflowdata().get("result").asInt()).isEqualTo(120);
        }
    }
}

