/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.quarkus.serverless.workflow.openapi;

import com.github.javaparser.StaticJavaParser;
import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.Modifier;
import com.github.javaparser.ast.body.ClassOrInterfaceDeclaration;
import com.github.javaparser.ast.body.MethodDeclaration;
import com.github.javaparser.ast.expr.CastExpr;
import com.github.javaparser.ast.expr.ClassExpr;
import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.ast.expr.MethodCallExpr;
import com.github.javaparser.ast.expr.NameExpr;
import com.github.javaparser.ast.expr.NullLiteralExpr;
import com.github.javaparser.ast.expr.StringLiteralExpr;
import com.github.javaparser.ast.stmt.BlockStmt;
import com.github.javaparser.ast.stmt.ReturnStmt;
import com.github.javaparser.ast.stmt.Statement;
import com.github.javaparser.ast.type.ClassOrInterfaceType;
import io.quarkiverse.openapi.generator.annotations.GeneratedClass;
import io.quarkiverse.openapi.generator.annotations.GeneratedMethod;
import io.quarkiverse.openapi.generator.annotations.GeneratedParam;
import java.lang.annotation.Annotation;
import java.util.Iterator;
import java.util.Map;
import java.util.stream.Stream;
import javax.enterprise.context.ApplicationScoped;
import javax.ws.rs.core.Response;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.MethodInfo;
import org.jboss.jandex.Type;
import org.kie.kogito.codegen.api.context.KogitoBuildContext;
import org.kie.kogito.quarkus.serverless.workflow.ClassAnnotatedWorkflowHandlerGenerator;
import org.kie.kogito.quarkus.serverless.workflow.WorkflowCodeGenUtils;
import org.kie.kogito.quarkus.serverless.workflow.WorkflowHandlerGeneratedFile;
import org.kie.kogito.serverless.workflow.openapi.OpenApiWorkItemHandler;
import org.kie.kogito.serverless.workflow.utils.OpenAPIWorkflowUtils;

public class WorkflowOpenApiHandlerGenerator
extends ClassAnnotatedWorkflowHandlerGenerator {
    private static final DotName generatedMethod = DotName.createSimple((String)GeneratedMethod.class.getCanonicalName());
    private static final DotName generatedParam = DotName.createSimple((String)GeneratedParam.class.getCanonicalName());
    private static final String WORK_ITEM_PARAMETERS = "parameters";
    private static final String OPEN_API_REF = "openApiRef";
    public static final WorkflowOpenApiHandlerGenerator instance = new WorkflowOpenApiHandlerGenerator();

    private WorkflowOpenApiHandlerGenerator() {
    }

    @Override
    protected Stream<WorkflowHandlerGeneratedFile> generateHandler(KogitoBuildContext context, AnnotationInstance a) {
        String fileName = a.value().asString();
        ClassInfo classInfo = a.target().asClass();
        return classInfo.methods().stream().filter(m -> m.hasAnnotation(generatedMethod)).map(m -> this.generateHandler(context, classInfo, fileName, (MethodInfo)m));
    }

    private WorkflowHandlerGeneratedFile generateHandler(KogitoBuildContext context, ClassInfo classInfo, String fileName, MethodInfo m) {
        String packageName = context.getPackageName();
        String className = OpenAPIWorkflowUtils.getOpenApiClassName((String)fileName, (String)m.name());
        ClassOrInterfaceType classNameType = StaticJavaParser.parseClassOrInterfaceType((String)classInfo.name().toString());
        CompilationUnit unit = new CompilationUnit(packageName);
        ClassOrInterfaceDeclaration clazz = unit.addClass(className);
        clazz.addExtendedType((ClassOrInterfaceType)StaticJavaParser.parseClassOrInterfaceType((String)OpenApiWorkItemHandler.class.getCanonicalName()).setTypeArguments(new com.github.javaparser.ast.type.Type[]{classNameType}));
        clazz.addAnnotation(ApplicationScoped.class);
        MethodDeclaration executeMethod = (MethodDeclaration)((MethodDeclaration)((MethodDeclaration)clazz.addMethod("internalExecute", new Modifier.Keyword[]{Modifier.Keyword.PROTECTED}).addParameter((com.github.javaparser.ast.type.Type)classNameType, OPEN_API_REF)).addParameter((com.github.javaparser.ast.type.Type)StaticJavaParser.parseClassOrInterfaceType((String)Map.class.getCanonicalName()).setTypeArguments(new com.github.javaparser.ast.type.Type[]{StaticJavaParser.parseClassOrInterfaceType((String)String.class.getCanonicalName()), StaticJavaParser.parseClassOrInterfaceType((String)Object.class.getCanonicalName())}), WORK_ITEM_PARAMETERS)).setType(Object.class);
        BlockStmt body = executeMethod.createBody();
        MethodCallExpr methodCallExpr = new MethodCallExpr((Expression)new NameExpr(OPEN_API_REF), m.name());
        NameExpr parameters = new NameExpr(WORK_ITEM_PARAMETERS);
        if (m.returnType().name().equals((Object)DotName.createSimple((String)Response.class.getName()))) {
            ((BlockStmt)body.addStatement((Expression)methodCallExpr)).addStatement((Statement)new ReturnStmt((Expression)new NullLiteralExpr()));
        } else {
            body.addStatement((Statement)new ReturnStmt((Expression)methodCallExpr));
        }
        AnnotationInstance[] annotations = new AnnotationInstance[m.parameters().size()];
        Iterator iterator = m.annotations(generatedParam).iterator();
        while (iterator.hasNext()) {
            AnnotationInstance a;
            annotations[a.target().asMethodParameter().position()] = a = (AnnotationInstance)iterator.next();
        }
        for (int i = 0; i < annotations.length; ++i) {
            AnnotationInstance annotation = annotations[i];
            Type param = m.args()[i];
            if (annotation != null) {
                methodCallExpr.addArgument((Expression)new CastExpr(this.fromClass(param), (Expression)new MethodCallExpr((Expression)parameters, "remove").addArgument((Expression)new StringLiteralExpr(annotation.value().asString()))));
                continue;
            }
            methodCallExpr.addArgument((Expression)((MethodCallExpr)new MethodCallExpr("buildBody", new Expression[0]).addArgument((Expression)parameters)).addArgument((Expression)new ClassExpr(this.fromClass(param))));
        }
        clazz.addMethod("getRestClass", new Modifier.Keyword[]{Modifier.Keyword.PROTECTED}).setType((com.github.javaparser.ast.type.Type)StaticJavaParser.parseClassOrInterfaceType((String)Class.class.getCanonicalName()).setTypeArguments(new com.github.javaparser.ast.type.Type[]{classNameType})).setBody((BlockStmt)new BlockStmt().addStatement((Statement)new ReturnStmt((Expression)new ClassExpr((com.github.javaparser.ast.type.Type)classNameType))));
        String operationId = m.annotation(generatedMethod).value().asString();
        String workItemHandlerName = OpenAPIWorkflowUtils.getOpenApiWorkItemName((String)fileName, (String)operationId);
        clazz.addMethod("getName", new Modifier.Keyword[]{Modifier.Keyword.PUBLIC}).setType((com.github.javaparser.ast.type.Type)StaticJavaParser.parseClassOrInterfaceType((String)String.class.getCanonicalName())).setBody((BlockStmt)new BlockStmt().addStatement((Statement)new ReturnStmt((Expression)new StringLiteralExpr(workItemHandlerName))));
        return WorkflowCodeGenUtils.fromCompilationUnit(workItemHandlerName, context, unit, className);
    }

    @Override
    protected Class<? extends Annotation> getAnnotation() {
        return GeneratedClass.class;
    }
}

