/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.quarkus.serverless.workflow.deployment.livereload;

import io.quarkus.arc.deployment.GeneratedBeanBuildItem;
import io.quarkus.bootstrap.classloading.ClassPathElement;
import io.quarkus.bootstrap.classloading.MemoryClassPathElement;
import io.quarkus.bootstrap.classloading.PathTreeClassPathElement;
import io.quarkus.bootstrap.classloading.QuarkusClassLoader;
import io.quarkus.bootstrap.model.ApplicationModel;
import io.quarkus.bootstrap.prebuild.CodeGenException;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.CodeGenContext;
import io.quarkus.deployment.IsDevelopment;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.builditem.CombinedIndexBuildItem;
import io.quarkus.deployment.builditem.GeneratedResourceBuildItem;
import io.quarkus.deployment.builditem.LiveReloadBuildItem;
import io.quarkus.deployment.builditem.RunTimeConfigBuilderBuildItem;
import io.quarkus.deployment.index.IndexingUtil;
import io.quarkus.deployment.pkg.builditem.CurateOutcomeBuildItem;
import io.quarkus.deployment.pkg.builditem.OutputTargetBuildItem;
import io.quarkus.paths.PathTree;
import io.quarkus.runtime.configuration.ConfigUtils;
import io.quarkus.runtime.configuration.QuarkusConfigFactory;
import io.smallrye.config.SmallRyeConfig;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.ServiceLoader;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.inject.Inject;
import org.drools.codegen.common.DroolsModelBuildContext;
import org.drools.codegen.common.GeneratedFile;
import org.drools.codegen.common.GeneratedFileType;
import org.drools.drl.quarkus.util.deployment.DroolsQuarkusResourceUtils;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.ConfigProvider;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.Indexer;
import org.kie.kogito.codegen.api.context.KogitoBuildContext;
import org.kie.kogito.quarkus.common.deployment.KogitoAddonsPreGeneratedSourcesBuildItem;
import org.kie.kogito.quarkus.common.deployment.KogitoBuildContextBuildItem;
import org.kie.kogito.quarkus.common.deployment.KogitoQuarkusResourceUtils;
import org.kie.kogito.quarkus.common.deployment.LiveReloadExecutionBuildItem;
import org.kie.kogito.quarkus.serverless.workflow.config.LiveReloadConfigBuilder;
import org.kie.kogito.quarkus.serverless.workflow.deployment.livereload.LiveReloadableCodeGenProvider;
import org.kie.kogito.quarkus.serverless.workflow.deployment.livereload.SkipLiveReload;

public class LiveReloadProcessor {
    private final LiveReloadBuildItem liveReloadBuildItem;
    private final ApplicationModel applicationModel;
    private final Path workDir;
    private final IndexView computingIndex;
    private final IndexView index;
    private final KogitoBuildContext kogitoBuildContext;
    private final QuarkusClassLoader.Builder classLoader;

    @Inject
    public LiveReloadProcessor(CombinedIndexBuildItem combinedIndexBuildItem, LiveReloadBuildItem liveReloadBuildItem, CurateOutcomeBuildItem curateOutcomeBuildItem, OutputTargetBuildItem outputTargetBuildItem, KogitoBuildContextBuildItem contextBuildItem) {
        this.liveReloadBuildItem = liveReloadBuildItem;
        this.applicationModel = curateOutcomeBuildItem.getApplicationModel();
        this.workDir = outputTargetBuildItem.getOutputDirectory();
        this.computingIndex = combinedIndexBuildItem.getComputingIndex();
        this.index = combinedIndexBuildItem.getIndex();
        this.kogitoBuildContext = contextBuildItem.getKogitoBuildContext();
        this.classLoader = QuarkusClassLoader.builder((String)"liveReload", (ClassLoader)this.kogitoBuildContext.getClassLoader(), (boolean)false);
    }

    @BuildStep(onlyIf={IsDevelopment.class})
    public LiveReloadExecutionBuildItem liveReload(BuildProducer<KogitoAddonsPreGeneratedSourcesBuildItem> sourcesProducer, BuildProducer<GeneratedResourceBuildItem> genResBI, BuildProducer<RunTimeConfigBuilderBuildItem> configBuilder) {
        ArrayList generatedFiles = new ArrayList();
        ArrayList indexViews = new ArrayList();
        if (this.liveReloadBuildItem.isLiveReload()) {
            if (this.shouldSkipLiveReload()) {
                this.dontSkipNextLiveReload();
            } else {
                ServiceLoader.load(LiveReloadableCodeGenProvider.class).stream().map(ServiceLoader.Provider::get).map(this::generateCode).forEach(codeGenerationResult -> {
                    generatedFiles.addAll(codeGenerationResult.getGeneratedFiles());
                    indexViews.add(codeGenerationResult.getIndexView());
                });
            }
        }
        configBuilder.produce((BuildItem)new RunTimeConfigBuilderBuildItem(LiveReloadConfigBuilder.class.getCanonicalName()));
        if (!generatedFiles.isEmpty()) {
            sourcesProducer.produce((BuildItem)new KogitoAddonsPreGeneratedSourcesBuildItem(generatedFiles));
            this.skipNextLiveReload();
            QuarkusClassLoader reloadedClassLoader = this.classLoader.build();
            QuarkusConfigFactory.setConfig((SmallRyeConfig)ConfigUtils.emptyConfigBuilder().addDefaultSources().addDiscoveredSources().forClassLoader((ClassLoader)reloadedClassLoader).build());
            return new LiveReloadExecutionBuildItem(KogitoQuarkusResourceUtils.generateAggregatedIndexNew((IndexView)this.computingIndex, indexViews), (ClassLoader)reloadedClassLoader);
        }
        this.dontSkipNextLiveReload();
        return new LiveReloadExecutionBuildItem(this.computingIndex);
    }

    private CodeGenerationResult generateCode(LiveReloadableCodeGenProvider codeGenProvider) {
        try {
            ArrayList<GeneratedFile> generatedFiles = new ArrayList<GeneratedFile>(this.generateSources(codeGenProvider));
            Collection<GeneratedBeanBuildItem> generatedBeans = this.compileGeneratedSources(generatedFiles);
            if (!generatedBeans.isEmpty()) {
                this.classLoader.addElement((ClassPathElement)new MemoryClassPathElement(generatedBeans.stream().collect(Collectors.toMap(x -> x.getName().replace('.', '/').concat(".class"), GeneratedBeanBuildItem::getData)), true));
            }
            return !generatedFiles.isEmpty() ? new CodeGenerationResult(generatedFiles, this.indexCompiledSources(generatedBeans)) : new CodeGenerationResult(List.of(), this.computingIndex);
        }
        catch (CodeGenException e) {
            throw new IllegalStateException(e);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private IndexView indexCompiledSources(Collection<GeneratedBeanBuildItem> generatedBeanBuildItems) {
        Indexer kogitoIndexer = new Indexer();
        for (GeneratedBeanBuildItem generatedBeanBuildItem : generatedBeanBuildItems) {
            IndexingUtil.indexClass((String)generatedBeanBuildItem.getName(), (Indexer)kogitoIndexer, (IndexView)this.index, new HashSet(), (ClassLoader)this.kogitoBuildContext.getClassLoader(), (byte[])generatedBeanBuildItem.getData());
        }
        return kogitoIndexer.complete();
    }

    private Collection<GeneratedBeanBuildItem> compileGeneratedSources(Collection<GeneratedFile> sources) {
        return DroolsQuarkusResourceUtils.compileGeneratedSources((DroolsModelBuildContext)this.kogitoBuildContext, (Collection)this.applicationModel.getRuntimeDependencies(), sources, (boolean)true);
    }

    private Collection<GeneratedFile> generateSources(LiveReloadableCodeGenProvider codeGenProvider) throws CodeGenException, IOException {
        Path outDir = this.workDir.resolve("generated-sources").resolve(codeGenProvider.providerId());
        ArrayList<GeneratedFile> generatedFiles = new ArrayList<GeneratedFile>();
        Config config = ConfigProvider.getConfig();
        for (Path sourcePath : this.kogitoBuildContext.getAppPaths().getSourcePaths()) {
            Path inputDir = sourcePath.resolve("main").resolve(codeGenProvider.inputDirectory());
            CodeGenContext codeGenContext = new CodeGenContext(this.applicationModel, outDir, this.workDir, inputDir, false, config, false);
            if (!codeGenProvider.shouldRun(inputDir, config) || !codeGenProvider.trigger(codeGenContext)) continue;
            try (Stream<Path> sources = Files.walk(outDir, new FileVisitOption[0]);){
                sources.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).forEach(p -> this.processSource((Path)p, outDir, (Collection<GeneratedFile>)generatedFiles));
            }
            Path classPath = outDir.getParent().getParent().resolve("classes");
            Path serviceLoaderPath = classPath.resolve("META-INF/services");
            if (!Files.isDirectory(classPath, new LinkOption[0]) || !Files.isDirectory(serviceLoaderPath, new LinkOption[0])) continue;
            this.classLoader.addElement((ClassPathElement)new PathTreeClassPathElement(PathTree.ofDirectoryOrFile((Path)classPath), true));
        }
        return generatedFiles;
    }

    private void processSource(Path path, Path outDir, Collection<GeneratedFile> generatedFiles) {
        if (path.toString().endsWith(".java")) {
            try {
                generatedFiles.add(new GeneratedFile(GeneratedFileType.SOURCE, outDir.relativize(path), Files.readAllBytes(path)));
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
    }

    private void skipNextLiveReload() {
        this.liveReloadBuildItem.setContextObject(SkipLiveReload.class, (Object)SkipLiveReload.TRUE);
    }

    private void dontSkipNextLiveReload() {
        this.liveReloadBuildItem.setContextObject(SkipLiveReload.class, (Object)SkipLiveReload.FALSE);
    }

    private boolean shouldSkipLiveReload() {
        if (this.liveReloadBuildItem.getContextObject(SkipLiveReload.class) != null) {
            return this.liveReloadBuildItem.getContextObject(SkipLiveReload.class) == SkipLiveReload.TRUE;
        }
        return false;
    }

    @BuildStep(onlyIfNot={IsDevelopment.class})
    public LiveReloadExecutionBuildItem executeWhenNotDevelopment() {
        return new LiveReloadExecutionBuildItem(this.computingIndex);
    }

    private static class CodeGenerationResult {
        private final Collection<GeneratedFile> generatedFiles;
        private final IndexView indexView;

        CodeGenerationResult(Collection<GeneratedFile> generatedFiles, IndexView indexView) {
            this.generatedFiles = generatedFiles;
            this.indexView = indexView;
        }

        Collection<GeneratedFile> getGeneratedFiles() {
            return this.generatedFiles;
        }

        IndexView getIndexView() {
            return this.indexView;
        }
    }
}

