/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.quarkus.serverless.workflow.asyncapi;

import io.quarkiverse.asyncapi.generator.input.AsyncAPISpecInput;
import io.quarkiverse.asyncapi.generator.input.AsyncApiSpecInputProvider;
import io.quarkus.deployment.CodeGenContext;
import io.serverlessworkflow.api.functions.FunctionDefinition;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.kie.kogito.quarkus.serverless.workflow.WorkflowCodeGenUtils;
import org.kie.kogito.quarkus.serverless.workflow.asyncapi.AsyncInputStreamSupplier;

public class WorkflowAsyncApiSpecInputProvider
implements AsyncApiSpecInputProvider {
    private static final String KOGITO_PACKAGE_PREFIX = "org.kie.kogito.asyncAPI";

    public AsyncAPISpecInput read(CodeGenContext context) {
        AsyncAPISpecInput asyncAPISpecInput;
        block9: {
            Path inputDir = context.inputDir();
            while (!Files.exists(inputDir, new LinkOption[0])) {
                inputDir = inputDir.getParent();
            }
            Stream<Path> workflowFiles = Files.walk(inputDir, new FileVisitOption[0]);
            try {
                asyncAPISpecInput = new AsyncAPISpecInput(WorkflowCodeGenUtils.operationResources(workflowFiles, f -> f.getType() == FunctionDefinition.Type.ASYNCAPI, context).collect(Collectors.toMap(resource -> resource.getOperationId().getFileName(), AsyncInputStreamSupplier::new, (key1, key2) -> key1)), KOGITO_PACKAGE_PREFIX);
                if (workflowFiles == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (workflowFiles != null) {
                        try {
                            workflowFiles.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException io) {
                    throw new IllegalStateException(io);
                }
            }
            workflowFiles.close();
        }
        return asyncAPISpecInput;
    }
}

