/*
 * Copyright 2023 Red Hat, Inc. and/or its affiliates.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *       http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.kie.kogito.quarkus.serverless.workflow.deployment.livereload;

import org.kie.kogito.quarkus.serverless.workflow.rpc.WorkflowRPCCodeGenProvider;

/**
 * Wrapper for {@link WorkflowRPCCodeGenProvider} that implements the {@link LiveReloadableCodeGenProvider} Service Provider Interface.
 */
public class LiveReloadableWorkflowRPCCodeGenProvider extends LiveReloadableCodeGenProviderBase<WorkflowRPCCodeGenProvider> {

    public LiveReloadableWorkflowRPCCodeGenProvider() {
        super(new WorkflowRPCCodeGenProvider());
    }
}
