/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.quarkus.serverless.workflow.rpc;

import io.quarkus.bootstrap.prebuild.CodeGenException;
import io.quarkus.deployment.CodeGenContext;
import io.quarkus.deployment.CodeGenProvider;
import io.serverlessworkflow.api.functions.FunctionDefinition;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.kie.kogito.quarkus.serverless.workflow.WorkflowCodeGenUtils;
import org.kie.kogito.quarkus.serverless.workflow.WorkflowOperationResource;
import org.kie.kogito.quarkus.serverless.workflow.rpc.ProtocUtils;
import org.kie.kogito.serverless.workflow.io.ClassPathContentLoader;
import org.kie.kogito.serverless.workflow.io.FileContentLoader;
import org.kie.kogito.serverless.workflow.io.URIContentLoader;
import org.kie.kogito.serverless.workflow.io.URIContentLoaderFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WorkflowRPCCodeGenProvider
implements CodeGenProvider {
    private static final Logger logger = LoggerFactory.getLogger(WorkflowRPCCodeGenProvider.class);

    public String providerId() {
        return "serverless-workflow-grpc";
    }

    public String inputExtension() {
        return "json";
    }

    public String inputDirectory() {
        return "resources";
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean trigger(CodeGenContext context) throws CodeGenException {
        try (Stream<Path> rpcFilePaths = Files.walk(context.inputDir(), new FileVisitOption[0]);){
            Path outputPath = context.workDir().resolve("proto_temp");
            Files.createDirectories(outputPath, new FileAttribute[0]);
            Collection protoFiles = WorkflowCodeGenUtils.operationResources(rpcFilePaths, this::isRPC, context).map(r -> this.getPath((WorkflowOperationResource)r, outputPath)).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
            logger.debug("Collected proto paths are {}", (Object)protoFiles);
            if (protoFiles.isEmpty()) {
                boolean bl2 = false;
                return bl2;
            }
            ProtocUtils.generateDescriptor(protoFiles, context);
            boolean bl = true;
            return bl;
        }
        catch (IOException io) {
            throw new CodeGenException((Throwable)io);
        }
    }

    public Optional<Path> getPath(WorkflowOperationResource resource, Path outputPath) {
        URIContentLoader contentLoader = resource.getContentLoader();
        logger.debug("Checking if resource {} should be writen to {}", (Object)resource, (Object)outputPath);
        switch (contentLoader.type()) {
            case FILE: {
                return Optional.of(((FileContentLoader)contentLoader).getPath());
            }
            case CLASSPATH: {
                return ((ClassPathContentLoader)contentLoader).getResource().map(this::fromURL);
            }
            case HTTP: {
                try {
                    Path tempPath = outputPath.resolve(resource.getOperationId().getFileName());
                    Files.write(tempPath, URIContentLoaderFactory.readAllBytes((URIContentLoader)contentLoader), new OpenOption[0]);
                    return Optional.of(tempPath);
                }
                catch (IOException io) {
                    throw new IllegalStateException(io);
                }
            }
        }
        logger.warn("Unsupported content loader {}", (Object)contentLoader);
        return Optional.empty();
    }

    private Path fromURL(URL url) {
        try {
            return Path.of(url.toURI());
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("Invalid URI " + url, e);
        }
    }

    private boolean isRPC(FunctionDefinition function) {
        return function.getType() == FunctionDefinition.Type.RPC;
    }
}

