/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.quarkus.serverless.workflow.deployment;

import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.builditem.CombinedIndexBuildItem;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import io.quarkus.deployment.builditem.nativeimage.NativeImageResourceBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ServiceProviderBuildItem;
import io.quarkus.deployment.pkg.steps.NativeOrNativeSourcesBuild;
import io.quarkus.smallrye.openapi.deployment.spi.AddToOpenAPIDefinitionBuildItem;
import io.serverlessworkflow.api.Workflow;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.microprofile.openapi.OASFilter;
import org.jboss.jandex.IndexView;
import org.kie.kogito.codegen.api.context.KogitoBuildContext;
import org.kie.kogito.codegen.core.io.CollectedResourceProducer;
import org.kie.kogito.process.expr.ExpressionHandler;
import org.kie.kogito.quarkus.common.deployment.KogitoAddonsPreGeneratedSourcesBuildItem;
import org.kie.kogito.quarkus.common.deployment.KogitoBuildContextBuildItem;
import org.kie.kogito.quarkus.serverless.workflow.WorkflowCodeGenUtils;
import org.kie.kogito.quarkus.serverless.workflow.WorkflowHandlerGeneratedFile;
import org.kie.kogito.quarkus.serverless.workflow.WorkflowHandlerGenerator;
import org.kie.kogito.quarkus.serverless.workflow.openapi.WorkflowOpenApiHandlerGenerator;
import org.kie.kogito.quarkus.serverless.workflow.rpc.WorkflowRPCHandlerGenerator;
import org.kie.kogito.serverless.workflow.openapi.ServerlessWorkflowOASFilter;
import org.kie.kogito.serverless.workflow.parser.FunctionNamespace;
import org.kie.kogito.serverless.workflow.parser.FunctionTypeHandler;
import org.kie.kogito.serverless.workflow.parser.schema.OpenApiModelSchemaGenerator;
import org.kie.kogito.serverless.workflow.parser.schema.OpenApiModelSchemaUtil;

public class ServerlessWorkflowAssetsProcessor {
    private static WorkflowHandlerGenerator[] generators = new WorkflowHandlerGenerator[]{WorkflowOpenApiHandlerGenerator.instance, WorkflowRPCHandlerGenerator.instance};

    @BuildStep
    FeatureBuildItem featureBuildItem() {
        return new FeatureBuildItem("kogito-serverless-workflow");
    }

    @BuildStep(onlyIf={NativeOrNativeSourcesBuild.class})
    NativeImageResourceBuildItem addExpressionHandlers(BuildProducer<ServiceProviderBuildItem> serviceProvider) {
        serviceProvider.produce((BuildItem)ServiceProviderBuildItem.allProvidersFromClassPath((String)ExpressionHandler.class.getCanonicalName()));
        serviceProvider.produce((BuildItem)ServiceProviderBuildItem.allProvidersFromClassPath((String)FunctionNamespace.class.getCanonicalName()));
        serviceProvider.produce((BuildItem)ServiceProviderBuildItem.allProvidersFromClassPath((String)FunctionTypeHandler.class.getCanonicalName()));
        return new NativeImageResourceBuildItem(new String[]{"protobuf/descriptor-sets/output.protobin"});
    }

    @BuildStep
    void addWorkItemHandlers(KogitoBuildContextBuildItem contextBI, CombinedIndexBuildItem indexBuildItem, BuildProducer<KogitoAddonsPreGeneratedSourcesBuildItem> sources) {
        KogitoBuildContext context = contextBI.getKogitoBuildContext();
        IndexView index = indexBuildItem.getIndex();
        ArrayList<WorkflowHandlerGeneratedFile> generatedFiles = new ArrayList<WorkflowHandlerGeneratedFile>();
        for (WorkflowHandlerGenerator generator : generators) {
            for (WorkflowHandlerGeneratedFile generated : generator.generateHandlerClasses(context, index)) {
                generatedFiles.add(generated);
                context.addGeneratedHandler(generated.getWorkItemHandlerName());
            }
        }
        sources.produce((BuildItem)new KogitoAddonsPreGeneratedSourcesBuildItem(generatedFiles));
    }

    @BuildStep
    void addOpenAPIModelSchema(KogitoBuildContextBuildItem contextBuildItem, BuildProducer<AddToOpenAPIDefinitionBuildItem> openAPIProducer) {
        Collection inputModelSchemaInfos = ServerlessWorkflowAssetsProcessor.getWorkflows(contextBuildItem.getKogitoBuildContext()).map(ServerlessWorkflowAssetsProcessor::workflowToSchemaInfo).filter(Objects::nonNull).collect(Collectors.toList());
        openAPIProducer.produce((BuildItem)new AddToOpenAPIDefinitionBuildItem((OASFilter)new ServerlessWorkflowOASFilter(inputModelSchemaInfos)));
    }

    private static ServerlessWorkflowOASFilter.SchemaInfo workflowToSchemaInfo(Workflow workflow) {
        return OpenApiModelSchemaGenerator.generateOpenAPIModelSchema((Workflow)workflow).map(openAPI -> new ServerlessWorkflowOASFilter.SchemaInfo(workflow.getId(), openAPI, OpenApiModelSchemaUtil.getInputModelRef((String)workflow.getId()))).orElse(null);
    }

    private static Stream<Workflow> getWorkflows(KogitoBuildContext kogitoBuildContext) {
        Path[] paths = kogitoBuildContext.getAppPaths().getPaths();
        Stream<Path> workflowFiles = CollectedResourceProducer.fromPaths((Path[])paths).stream().map(collectedResource -> collectedResource.resource().getSourcePath()).map(x$0 -> Paths.get(x$0, new String[0]));
        return WorkflowCodeGenUtils.getWorkflows(workflowFiles);
    }
}

