/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.quarkus.serverless.workflow;

import com.github.javaparser.ast.CompilationUnit;
import io.quarkus.deployment.CodeGenContext;
import io.serverlessworkflow.api.Workflow;
import io.serverlessworkflow.api.functions.FunctionDefinition;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.drools.codegen.common.GeneratedFile;
import org.drools.codegen.common.GeneratedFileType;
import org.kie.kogito.codegen.api.context.KogitoBuildContext;
import org.kie.kogito.codegen.process.ProcessCodegen;
import org.kie.kogito.quarkus.serverless.workflow.WorkflowHandlerGeneratedFile;
import org.kie.kogito.quarkus.serverless.workflow.WorkflowOperationResource;
import org.kie.kogito.serverless.workflow.io.URIContentLoaderFactory;
import org.kie.kogito.serverless.workflow.operationid.WorkflowOperationId;
import org.kie.kogito.serverless.workflow.operationid.WorkflowOperationIdFactory;
import org.kie.kogito.serverless.workflow.operationid.WorkflowOperationIdFactoryProvider;
import org.kie.kogito.serverless.workflow.utils.ServerlessWorkflowUtils;

public class WorkflowCodeGenUtils {
    private WorkflowCodeGenUtils() {
    }

    private static WorkflowOperationIdFactory operationIdFactory(CodeGenContext context) {
        return WorkflowOperationIdFactoryProvider.getFactory((Optional)context.config().getOptionalValue("kogito.sw.operationIdStrategy", String.class));
    }

    public static Stream<WorkflowOperationResource> operationResources(Stream<Path> files, Predicate<FunctionDefinition> predicate, CodeGenContext context) {
        return WorkflowCodeGenUtils.getWorkflows(files).flatMap(w -> WorkflowCodeGenUtils.processFunction(w, predicate, WorkflowCodeGenUtils.operationIdFactory(context)));
    }

    public static Stream<Workflow> getWorkflows(Stream<Path> files) {
        return files.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).map(WorkflowCodeGenUtils::getWorkflow).filter(Optional::isPresent).map(Optional::get);
    }

    public static GeneratedFile fromCompilationUnit(KogitoBuildContext context, CompilationUnit unit, String className) {
        return new GeneratedFile(GeneratedFileType.SOURCE, Path.of("", context.getPackageName().split("\\.")).resolve(className + ".java"), unit.toString());
    }

    public static WorkflowHandlerGeneratedFile fromCompilationUnit(String workItemHandlerName, KogitoBuildContext context, CompilationUnit unit, String className) {
        return new WorkflowHandlerGeneratedFile(workItemHandlerName, GeneratedFileType.SOURCE, Path.of("", context.getPackageName().split("\\.")).resolve(className + ".java"), unit.toString());
    }

    private static Stream<WorkflowOperationResource> processFunction(Workflow workflow, Predicate<FunctionDefinition> predicate, WorkflowOperationIdFactory factory) {
        if (workflow.getFunctions() == null || workflow.getFunctions().getFunctionDefs() == null) {
            return Stream.empty();
        }
        return workflow.getFunctions().getFunctionDefs().stream().filter(predicate).map(f -> WorkflowCodeGenUtils.getResource(workflow, f, factory));
    }

    private static WorkflowOperationResource getResource(Workflow workflow, FunctionDefinition function, WorkflowOperationIdFactory factory) {
        WorkflowOperationId operationId = factory.from(workflow, function, Optional.empty());
        return new WorkflowOperationResource(operationId, URIContentLoaderFactory.buildLoader((URI)operationId.getUri(), (ClassLoader)Thread.currentThread().getContextClassLoader(), (Workflow)workflow, (String)function.getAuthRef()));
    }

    private static Optional<Workflow> getWorkflow(Path p) {
        return ProcessCodegen.SUPPORTED_SW_EXTENSIONS.entrySet().stream().filter(e -> p.getFileName().toString().endsWith((String)e.getKey())).map(e -> {
            Workflow workflow;
            block8: {
                BufferedReader r = Files.newBufferedReader(p);
                try {
                    workflow = ServerlessWorkflowUtils.getWorkflow((Reader)r, (String)((String)e.getValue()));
                    if (r == null) break block8;
                }
                catch (Throwable throwable) {
                    try {
                        if (r != null) {
                            try {
                                ((Reader)r).close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException ex) {
                        throw new IllegalStateException(ex);
                    }
                }
                ((Reader)r).close();
            }
            return workflow;
        }).findFirst();
    }
}

