/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.event.cloudevents.extension;

import io.cloudevents.CloudEvent;
import io.cloudevents.CloudEventExtension;
import io.cloudevents.CloudEventExtensions;
import io.cloudevents.core.builder.CloudEventBuilder;
import io.cloudevents.core.impl.BaseCloudEventBuilder;
import io.cloudevents.core.provider.ExtensionProvider;
import java.net.URI;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.kie.kogito.event.cloudevents.extension.KogitoExtension;

public class KogitoExtensionTest {
    private static final String TEST_ID = "test-cloudevent-id";
    private static final String TEST_SOURCE = "http://test-cloudevent-source";
    private static final String TEST_TYPE = "test-cloudevent-type";
    private static final String TEST_DATA = "\"TEST_DATA\"";
    private static final String TEST_EXECUTION_ID = "test-kogito-execution-id";
    private static final String TEST_DMN_MODEL_NAME = "test-kogito-dmn-model-name";
    private static final String TEST_DMN_MODEL_NAMESPACE = "test-kogito-dmn-model-namespace";
    private static final String TEST_DMN_EVALUATE_DECISION = "test-kogito-dmn-eval-decision";

    @BeforeAll
    static void registerExtension() {
        KogitoExtension.register();
    }

    @Test
    void writeExtension() {
        this.assertWriteExtension(null, null, null, null);
        this.assertWriteExtension(null, null, null, false);
        this.assertWriteExtension(null, null, null, true);
        this.assertWriteExtension(null, null, false, null);
        this.assertWriteExtension(null, null, false, false);
        this.assertWriteExtension(null, null, false, true);
        this.assertWriteExtension(null, null, true, null);
        this.assertWriteExtension(null, null, true, false);
        this.assertWriteExtension(null, null, true, true);
        this.assertWriteExtension(null, TEST_EXECUTION_ID, null, null);
        this.assertWriteExtension(null, TEST_EXECUTION_ID, null, false);
        this.assertWriteExtension(null, TEST_EXECUTION_ID, null, true);
        this.assertWriteExtension(null, TEST_EXECUTION_ID, false, null);
        this.assertWriteExtension(null, TEST_EXECUTION_ID, false, false);
        this.assertWriteExtension(null, TEST_EXECUTION_ID, false, true);
        this.assertWriteExtension(null, TEST_EXECUTION_ID, true, null);
        this.assertWriteExtension(null, TEST_EXECUTION_ID, true, false);
        this.assertWriteExtension(null, TEST_EXECUTION_ID, true, true);
        this.assertWriteExtension(TEST_DMN_EVALUATE_DECISION, null, null, null);
        this.assertWriteExtension(TEST_DMN_EVALUATE_DECISION, null, null, false);
        this.assertWriteExtension(TEST_DMN_EVALUATE_DECISION, null, null, true);
        this.assertWriteExtension(TEST_DMN_EVALUATE_DECISION, null, false, null);
        this.assertWriteExtension(TEST_DMN_EVALUATE_DECISION, null, false, false);
        this.assertWriteExtension(TEST_DMN_EVALUATE_DECISION, null, false, true);
        this.assertWriteExtension(TEST_DMN_EVALUATE_DECISION, null, true, null);
        this.assertWriteExtension(TEST_DMN_EVALUATE_DECISION, null, true, false);
        this.assertWriteExtension(TEST_DMN_EVALUATE_DECISION, null, true, true);
        this.assertWriteExtension(TEST_DMN_EVALUATE_DECISION, TEST_EXECUTION_ID, null, null);
        this.assertWriteExtension(TEST_DMN_EVALUATE_DECISION, TEST_EXECUTION_ID, null, false);
        this.assertWriteExtension(TEST_DMN_EVALUATE_DECISION, TEST_EXECUTION_ID, null, true);
        this.assertWriteExtension(TEST_DMN_EVALUATE_DECISION, TEST_EXECUTION_ID, false, null);
        this.assertWriteExtension(TEST_DMN_EVALUATE_DECISION, TEST_EXECUTION_ID, false, false);
        this.assertWriteExtension(TEST_DMN_EVALUATE_DECISION, TEST_EXECUTION_ID, false, true);
        this.assertWriteExtension(TEST_DMN_EVALUATE_DECISION, TEST_EXECUTION_ID, true, null);
        this.assertWriteExtension(TEST_DMN_EVALUATE_DECISION, TEST_EXECUTION_ID, true, false);
        this.assertWriteExtension(TEST_DMN_EVALUATE_DECISION, TEST_EXECUTION_ID, true, true);
    }

    private void assertWriteExtension(String dmnEvaluateDecision, String executionId, Boolean dmnFullResult, Boolean dmnFilteredCtx) {
        CloudEvent event = this.cloudEventFromExtensionObject(dmnEvaluateDecision, executionId, dmnFullResult, dmnFilteredCtx);
        this.assertCloudEvent(event, dmnEvaluateDecision, executionId, dmnFullResult, dmnFilteredCtx);
    }

    @Test
    void parseExtension() {
        this.assertParseExtension(null, null, null, null);
        this.assertParseExtension(null, null, null, false);
        this.assertParseExtension(null, null, null, true);
        this.assertParseExtension(null, null, false, null);
        this.assertParseExtension(null, null, false, false);
        this.assertParseExtension(null, null, false, true);
        this.assertParseExtension(null, null, true, null);
        this.assertParseExtension(null, null, true, false);
        this.assertParseExtension(null, null, true, true);
        this.assertParseExtension(null, TEST_EXECUTION_ID, null, null);
        this.assertParseExtension(null, TEST_EXECUTION_ID, null, false);
        this.assertParseExtension(null, TEST_EXECUTION_ID, null, true);
        this.assertParseExtension(null, TEST_EXECUTION_ID, false, null);
        this.assertParseExtension(null, TEST_EXECUTION_ID, false, false);
        this.assertParseExtension(null, TEST_EXECUTION_ID, false, true);
        this.assertParseExtension(null, TEST_EXECUTION_ID, true, null);
        this.assertParseExtension(null, TEST_EXECUTION_ID, true, false);
        this.assertParseExtension(null, TEST_EXECUTION_ID, true, true);
        this.assertParseExtension(TEST_DMN_EVALUATE_DECISION, null, null, null);
        this.assertParseExtension(TEST_DMN_EVALUATE_DECISION, null, null, false);
        this.assertParseExtension(TEST_DMN_EVALUATE_DECISION, null, null, true);
        this.assertParseExtension(TEST_DMN_EVALUATE_DECISION, null, false, null);
        this.assertParseExtension(TEST_DMN_EVALUATE_DECISION, null, false, false);
        this.assertParseExtension(TEST_DMN_EVALUATE_DECISION, null, false, true);
        this.assertParseExtension(TEST_DMN_EVALUATE_DECISION, null, true, null);
        this.assertParseExtension(TEST_DMN_EVALUATE_DECISION, null, true, false);
        this.assertParseExtension(TEST_DMN_EVALUATE_DECISION, null, true, true);
        this.assertParseExtension(TEST_DMN_EVALUATE_DECISION, TEST_EXECUTION_ID, null, null);
        this.assertParseExtension(TEST_DMN_EVALUATE_DECISION, TEST_EXECUTION_ID, null, false);
        this.assertParseExtension(TEST_DMN_EVALUATE_DECISION, TEST_EXECUTION_ID, null, true);
        this.assertParseExtension(TEST_DMN_EVALUATE_DECISION, TEST_EXECUTION_ID, false, null);
        this.assertParseExtension(TEST_DMN_EVALUATE_DECISION, TEST_EXECUTION_ID, false, false);
        this.assertParseExtension(TEST_DMN_EVALUATE_DECISION, TEST_EXECUTION_ID, false, true);
        this.assertParseExtension(TEST_DMN_EVALUATE_DECISION, TEST_EXECUTION_ID, true, null);
        this.assertParseExtension(TEST_DMN_EVALUATE_DECISION, TEST_EXECUTION_ID, true, false);
        this.assertParseExtension(TEST_DMN_EVALUATE_DECISION, TEST_EXECUTION_ID, true, true);
    }

    private void assertParseExtension(String dmnEvaluateDecision, String executionId, Boolean dmnFullResult, Boolean dmnFilteredCtx) {
        KogitoExtension extension = this.extensionObjectFromCloudEvent(dmnEvaluateDecision, executionId, dmnFullResult, dmnFilteredCtx);
        this.assertExtension(extension, dmnEvaluateDecision, executionId, dmnFullResult, dmnFilteredCtx);
    }

    private CloudEvent cloudEventFromExtensionObject(String dmnEvaluateDecision, String executionId, Boolean dmnFullResult, Boolean dmnFilteredCtx) {
        KogitoExtension kogitoExt = new KogitoExtension();
        kogitoExt.setDmnModelName(TEST_DMN_MODEL_NAME);
        kogitoExt.setDmnModelNamespace(TEST_DMN_MODEL_NAMESPACE);
        if (dmnEvaluateDecision != null) {
            kogitoExt.setDmnEvaluateDecision(dmnEvaluateDecision);
        }
        if (executionId != null) {
            kogitoExt.setExecutionId(executionId);
        }
        if (dmnFullResult != null) {
            kogitoExt.setDmnFullResult(dmnFullResult);
        }
        if (dmnFilteredCtx != null) {
            kogitoExt.setDmnFilteredCtx(dmnFilteredCtx);
        }
        return ((io.cloudevents.core.v1.CloudEventBuilder)((io.cloudevents.core.v1.CloudEventBuilder)CloudEventBuilder.v1().withId(TEST_ID).withSource(URI.create(TEST_SOURCE)).withType(TEST_TYPE).withData(TEST_DATA.getBytes())).withExtension((CloudEventExtension)kogitoExt)).build();
    }

    private void assertCloudEvent(CloudEvent event, String dmnEvaluateDecision, String executionId, Boolean dmnFullResult, Boolean dmnFilteredCtx) {
        Assertions.assertThat((Object)event).isNotNull();
        Assertions.assertThat((Object)event.getExtension("kogitodmnmodelname")).isEqualTo((Object)TEST_DMN_MODEL_NAME);
        Assertions.assertThat((Object)event.getExtension("kogitodmnmodelnamespace")).isEqualTo((Object)TEST_DMN_MODEL_NAMESPACE);
        Assertions.assertThat((Object)event.getExtension("kogitodmnevaldecision")).isEqualTo((Object)dmnEvaluateDecision);
        Assertions.assertThat((Object)event.getExtension("kogitoexecutionid")).isEqualTo((Object)executionId);
        Assertions.assertThat((Object)event.getExtension("kogitodmnfullresult")).isEqualTo((Object)dmnFullResult);
        Assertions.assertThat((Object)event.getExtension("kogitodmnfilteredctx")).isEqualTo((Object)dmnFilteredCtx);
    }

    private KogitoExtension extensionObjectFromCloudEvent(String dmnEvaluateDecision, String executionId, Boolean dmnFullResult, Boolean dmnFilteredCtx) {
        BaseCloudEventBuilder builder = ((io.cloudevents.core.v1.CloudEventBuilder)((io.cloudevents.core.v1.CloudEventBuilder)CloudEventBuilder.v1().withId(TEST_ID).withSource(URI.create(TEST_SOURCE)).withType(TEST_TYPE).withData(TEST_DATA.getBytes())).withExtension("kogitodmnmodelname", TEST_DMN_MODEL_NAME)).withExtension("kogitodmnmodelnamespace", TEST_DMN_MODEL_NAMESPACE);
        if (dmnEvaluateDecision != null) {
            builder.withExtension("kogitodmnevaldecision", dmnEvaluateDecision);
        }
        if (executionId != null) {
            builder.withExtension("kogitoexecutionid", executionId);
        }
        if (dmnFullResult != null) {
            builder.withExtension("kogitodmnfullresult", dmnFullResult);
        }
        if (dmnFilteredCtx != null) {
            builder.withExtension("kogitodmnfilteredctx", dmnFilteredCtx);
        }
        return (KogitoExtension)ExtensionProvider.getInstance().parseExtension(KogitoExtension.class, (CloudEventExtensions)builder.build());
    }

    private void assertExtension(KogitoExtension kogitoExtension, String dmnEvaluateDecision, String executionId, Boolean dmnFullResult, Boolean dmnFilteredCtx) {
        Assertions.assertThat((Object)kogitoExtension).isNotNull();
        Assertions.assertThat((String)kogitoExtension.getDmnModelName()).isEqualTo(TEST_DMN_MODEL_NAME);
        Assertions.assertThat((String)kogitoExtension.getDmnModelNamespace()).isEqualTo(TEST_DMN_MODEL_NAMESPACE);
        Assertions.assertThat((String)kogitoExtension.getDmnEvaluateDecision()).isEqualTo(dmnEvaluateDecision);
        Assertions.assertThat((String)kogitoExtension.getExecutionId()).isEqualTo(executionId);
        Assertions.assertThat((Boolean)kogitoExtension.isDmnFullResult()).isSameAs((Object)dmnFullResult);
        Assertions.assertThat((Boolean)kogitoExtension.isDmnFilteredCtx()).isSameAs((Object)dmnFilteredCtx);
    }
}

