/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.event;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import io.cloudevents.SpecVersion;
import java.net.URI;
import java.time.OffsetDateTime;
import java.time.ZonedDateTime;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import org.kie.kogito.event.DataEvent;
import org.kie.kogito.event.cloudevents.SpecVersionDeserializer;
import org.kie.kogito.event.cloudevents.SpecVersionSerializer;
import org.kie.kogito.event.cloudevents.utils.CloudEventUtils;

@JsonIgnoreProperties(ignoreUnknown=true)
public abstract class AbstractDataEvent<T>
implements DataEvent<T> {
    public static final String TYPE_PREFIX = "process";
    public static final String TYPE_FORMAT = "process.%s.%s";
    public static final String SOURCE_FORMAT = "/process/%s";
    public static final String SPEC_VERSION = "1.0";
    @JsonDeserialize(using=SpecVersionDeserializer.class)
    @JsonSerialize(using=SpecVersionSerializer.class)
    @JsonProperty(value="specversion")
    private SpecVersion specVersion;
    private String id;
    private URI source;
    private String type;
    private OffsetDateTime time;
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    private String subject;
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    private String dataContentType;
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    private URI dataSchema;
    private T data;
    @JsonProperty(value="kogitoprocinstanceid")
    private String kogitoProcessInstanceId;
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    @JsonProperty(value="kogitorootprociid")
    private String kogitoRootProcessInstanceId;
    @JsonProperty(value="kogitoprocid")
    private String kogitoProcessId;
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    @JsonProperty(value="kogitorootprocid")
    private String kogitoRootProcessId;
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    @JsonProperty(value="kogitoaddons")
    private String kogitoAddons;
    private Map<String, Object> extensionAttributes = new HashMap<String, Object>();

    public AbstractDataEvent() {
    }

    public AbstractDataEvent(String type, String source, T body, String kogitoProcessInstanceId, String kogitoRootProcessInstanceId, String kogitoProcessId, String kogitoRootProcessId, String kogitoAddons) {
        this.specVersion = SpecVersion.parse((String)SPEC_VERSION);
        this.id = UUID.randomUUID().toString();
        this.source = Optional.ofNullable(source).map(URI::create).orElse(null);
        this.type = type;
        this.time = ZonedDateTime.now().toOffsetDateTime();
        this.data = body;
        this.kogitoProcessInstanceId = kogitoProcessInstanceId;
        this.kogitoRootProcessInstanceId = kogitoRootProcessInstanceId;
        this.kogitoProcessId = kogitoProcessId;
        this.kogitoRootProcessId = kogitoRootProcessId;
        this.kogitoAddons = kogitoAddons;
        this.ensureRequiredFields();
    }

    public AbstractDataEvent(String type, String source, T body, String kogitoProcessInstanceId, String kogitoRootProcessInstanceId, String kogitoProcessId, String kogitoRootProcessId, String kogitoAddons, String subject, String dataContentType, String dataSchema) {
        this(type, source, body, kogitoProcessInstanceId, kogitoRootProcessInstanceId, kogitoProcessId, kogitoRootProcessId, kogitoAddons);
        this.subject = subject;
        this.dataContentType = dataContentType;
        this.dataSchema = URI.create(dataSchema);
    }

    protected void ensureRequiredFields() {
        if (this.type == null || this.type.isEmpty()) {
            this.type = TYPE_PREFIX;
        }
        if (this.source == null || this.source.toString().isEmpty()) {
            this.source = URI.create(String.format(SOURCE_FORMAT, this.kogitoProcessId));
        }
    }

    public URI getSource() {
        return this.source;
    }

    public SpecVersion getSpecVersion() {
        return this.specVersion;
    }

    @Override
    public String getId() {
        return this.id;
    }

    public String getType() {
        return this.type;
    }

    public OffsetDateTime getTime() {
        return this.time;
    }

    @Override
    public T getData() {
        return this.data;
    }

    @Override
    public String getDataContentType() {
        return this.dataContentType;
    }

    public URI getDataSchema() {
        return this.dataSchema;
    }

    @Override
    public String getSubject() {
        return this.subject;
    }

    public String getKogitoProcessInstanceId() {
        return this.kogitoProcessInstanceId;
    }

    public String getKogitoRootProcessInstanceId() {
        return this.kogitoRootProcessInstanceId;
    }

    public String getKogitoProcessId() {
        return this.kogitoProcessId;
    }

    public String getKogitoRootProcessId() {
        return this.kogitoRootProcessId;
    }

    public String getKogitoAddons() {
        return this.kogitoAddons;
    }

    public Object getAttribute(String name) throws IllegalArgumentException {
        return CloudEventUtils.getAttribute(name, this);
    }

    public Object getExtension(String name) {
        return this.extensionAttributes.get(name);
    }

    @JsonIgnore
    public Set<String> getAttributeNames() {
        return DataEvent.super.getAttributeNames();
    }

    @JsonIgnore
    public Set<String> getExtensionNames() {
        return this.extensionAttributes.keySet();
    }

    @JsonAnySetter
    public void addExtensionAttribute(String name, Object value) {
        this.extensionAttributes.put(name, value);
    }

    @JsonAnyGetter
    @JsonIgnore
    public Map<String, Object> getExtensionAttributes() {
        return this.extensionAttributes;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AbstractDataEvent that = (AbstractDataEvent)o;
        return this.id.equals(that.id);
    }

    public int hashCode() {
        return Objects.hash(this.id);
    }

    public String toString() {
        return "AbstractDataEvent{specVersion=" + this.specVersion + ", id='" + this.id + "', source=" + this.source + ", type='" + this.type + "', time=" + this.time + ", subject='" + this.subject + "', dataContentType='" + this.dataContentType + "', dataSchema=" + this.dataSchema + ", data=" + this.data + ", kogitoProcessInstanceId='" + this.kogitoProcessInstanceId + "', kogitoRootProcessInstanceId='" + this.kogitoRootProcessInstanceId + "', kogitoProcessId='" + this.kogitoProcessId + "', kogitoRootProcessId='" + this.kogitoRootProcessId + "', kogitoAddons='" + this.kogitoAddons + "', extensionAttributes=" + this.extensionAttributes + "}";
    }
}

