/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.addon.quarkus.messaging.common;

import io.cloudevents.CloudEvent;
import io.cloudevents.CloudEventData;
import io.cloudevents.SpecVersion;
import io.cloudevents.core.builder.CloudEventBuilder;
import io.smallrye.reactive.messaging.ce.CloudEventMetadata;
import java.io.IOException;
import java.time.ZonedDateTime;
import java.util.Optional;
import org.eclipse.microprofile.reactive.messaging.Message;
import org.kie.kogito.event.CloudEventUnmarshaller;
import org.kie.kogito.event.Converter;
import org.kie.kogito.event.DataEvent;
import org.kie.kogito.event.DataEventFactory;
import org.kie.kogito.event.cloudevents.utils.CloudEventUtils;

public class QuarkusCloudEventConverter<I, T>
implements Converter<Message<I>, DataEvent<T>> {
    private final CloudEventUnmarshaller<I, T> unmarshaller;

    public QuarkusCloudEventConverter(CloudEventUnmarshaller<I, T> unmarshaller) {
        this.unmarshaller = unmarshaller;
    }

    public DataEvent<T> convert(Message<I> message) throws IOException {
        Optional metadata = message.getMetadata(CloudEventMetadata.class);
        return DataEventFactory.from((CloudEvent)(metadata.isPresent() ? this.binaryCE((CloudEventMetadata)metadata.get(), message.getPayload()) : (CloudEvent)this.unmarshaller.cloudEvent().convert(message.getPayload())), (Converter)this.unmarshaller.data());
    }

    private CloudEvent binaryCE(CloudEventMetadata<?> meta, I payload) throws IOException {
        CloudEventBuilder builder = CloudEventBuilder.fromSpecVersion((SpecVersion)SpecVersion.parse((String)meta.getSpecVersion())).withType(meta.getType()).withSource(meta.getSource()).withId(meta.getId());
        if (payload != null) {
            builder.withData((CloudEventData)this.unmarshaller.binaryCloudEvent().convert(payload));
        }
        meta.getDataContentType().ifPresent(arg_0 -> ((CloudEventBuilder)builder).withDataContentType(arg_0));
        meta.getDataSchema().ifPresent(arg_0 -> ((CloudEventBuilder)builder).withDataSchema(arg_0));
        meta.getTimeStamp().map(ZonedDateTime::toOffsetDateTime).ifPresent(arg_0 -> ((CloudEventBuilder)builder).withTime(arg_0));
        meta.getSubject().ifPresent(arg_0 -> ((CloudEventBuilder)builder).withSubject(arg_0));
        meta.getExtensions().forEach((k, v) -> CloudEventUtils.withExtension((CloudEventBuilder)builder, (String)k, (Object)v));
        return builder.build();
    }
}

