/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.addons.quarkus.knative.eventing;

import io.smallrye.config.ConfigSourceContext;
import io.smallrye.config.ConfigValue;
import java.util.Collection;
import org.assertj.core.api.Assertions;
import org.eclipse.microprofile.config.spi.ConfigSource;
import org.junit.jupiter.api.Test;
import org.kie.kogito.addons.quarkus.knative.eventing.KnativeEventingConfigSource;
import org.kie.kogito.addons.quarkus.knative.eventing.KnativeEventingConfigSourceFactory;
import org.mockito.Mockito;

class KnativeEventingConfigSourceFactoryTest {
    private static String DEFAULT_SINK_CONFIG = "${K_SINK:http://localhost:9090}";

    KnativeEventingConfigSourceFactoryTest() {
    }

    @Test
    void getConfigSourcesWithProcessEventsAndDefaultIncomeStream() {
        KnativeEventingConfigSource eventingConfigSource = KnativeEventingConfigSourceFactoryTest.buildKnativeEventingConfigSource("true", null);
        Assertions.assertThat((Collection)eventingConfigSource.getPropertyNames()).hasSize(10);
        KnativeEventingConfigSourceFactoryTest.assertProcessEvents(eventingConfigSource);
        KnativeEventingConfigSourceFactoryTest.assertDefaultIncomingConnector(eventingConfigSource);
        KnativeEventingConfigSourceFactoryTest.assertDefaultOutgoingConnector(eventingConfigSource);
    }

    @Test
    void getConfigSourcesWithProcessEvents() {
        KnativeEventingConfigSource eventingConfigSource = KnativeEventingConfigSourceFactoryTest.buildKnativeEventingConfigSource("true", "true");
        Assertions.assertThat((Collection)eventingConfigSource.getPropertyNames()).hasSize(8);
        KnativeEventingConfigSourceFactoryTest.assertProcessEvents(eventingConfigSource);
        KnativeEventingConfigSourceFactoryTest.assertDefaultOutgoingConnector(eventingConfigSource);
    }

    @Test
    void getConfigSourcesWithDefaultIncomeStream() {
        KnativeEventingConfigSource eventingConfigSource = KnativeEventingConfigSourceFactoryTest.buildKnativeEventingConfigSource(null, null);
        Assertions.assertThat((Collection)eventingConfigSource.getPropertyNames()).hasSize(4);
        KnativeEventingConfigSourceFactoryTest.assertDefaultOutgoingConnector(eventingConfigSource);
    }

    private static KnativeEventingConfigSource buildKnativeEventingConfigSource(String includeProcessEvents, String skipDefaultIncomingStream) {
        ConfigSourceContext context = (ConfigSourceContext)Mockito.mock(ConfigSourceContext.class);
        KnativeEventingConfigSourceFactoryTest.mockConfigValue(context, "org.kie.kogito.addons.quarkus.knative.eventing.includeProcessEvents", includeProcessEvents);
        KnativeEventingConfigSourceFactoryTest.mockConfigValue(context, "org.kie.kogito.addons.quarkus.knative.eventing.skipDefaultIncomingStream", skipDefaultIncomingStream);
        KnativeEventingConfigSourceFactoryTest.mockConfigValue(context, "K_SINK", null);
        ConfigSource configSource = (ConfigSource)new KnativeEventingConfigSourceFactory().getConfigSources(context).iterator().next();
        Assertions.assertThat((Object)configSource).isExactlyInstanceOf(KnativeEventingConfigSource.class);
        KnativeEventingConfigSource eventingConfigSource = (KnativeEventingConfigSource)configSource;
        Assertions.assertThat((String)eventingConfigSource.getName()).isEqualTo("KnativeEventingConfigSource");
        return eventingConfigSource;
    }

    private static void mockConfigValue(ConfigSourceContext context, String name, String value) {
        ConfigValue configValue = (ConfigValue)Mockito.mock(ConfigValue.class);
        ((ConfigValue)Mockito.doReturn((Object)value).when((Object)configValue)).getValue();
        ((ConfigSourceContext)Mockito.doReturn((Object)configValue).when((Object)context)).getValue(name);
    }

    private static void assertProcessEvents(KnativeEventingConfigSource eventingConfigSource) {
        KnativeEventingConfigSourceFactoryTest.assertContainsProperty(eventingConfigSource, "mp.messaging.outgoing.kogito-processinstances-events.connector", "quarkus-http");
        KnativeEventingConfigSourceFactoryTest.assertContainsProperty(eventingConfigSource, "mp.messaging.outgoing.kogito-processinstances-events.url", DEFAULT_SINK_CONFIG);
        KnativeEventingConfigSourceFactoryTest.assertContainsProperty(eventingConfigSource, "mp.messaging.outgoing.kogito-usertaskinstances-events.connector", "quarkus-http");
        KnativeEventingConfigSourceFactoryTest.assertContainsProperty(eventingConfigSource, "mp.messaging.outgoing.kogito-usertaskinstances-events.url", DEFAULT_SINK_CONFIG);
        KnativeEventingConfigSourceFactoryTest.assertContainsProperty(eventingConfigSource, "mp.messaging.outgoing.kogito-variables-events.connector", "quarkus-http");
        KnativeEventingConfigSourceFactoryTest.assertContainsProperty(eventingConfigSource, "mp.messaging.outgoing.kogito-variables-events.url", DEFAULT_SINK_CONFIG);
    }

    private static void assertDefaultIncomingConnector(KnativeEventingConfigSource eventingConfigSource) {
        KnativeEventingConfigSourceFactoryTest.assertContainsProperty(eventingConfigSource, "mp.messaging.incoming.kogito_incoming_stream.connector", "quarkus-http");
        KnativeEventingConfigSourceFactoryTest.assertContainsProperty(eventingConfigSource, "mp.messaging.incoming.kogito_incoming_stream.path", "/");
    }

    private static void assertDefaultOutgoingConnector(KnativeEventingConfigSource eventingConfigSource) {
        KnativeEventingConfigSourceFactoryTest.assertContainsProperty(eventingConfigSource, "mp.messaging.outgoing.kogito_outgoing_stream.connector", "quarkus-http");
        KnativeEventingConfigSourceFactoryTest.assertContainsProperty(eventingConfigSource, "mp.messaging.outgoing.kogito_outgoing_stream.url", DEFAULT_SINK_CONFIG);
    }

    private static void assertContainsProperty(KnativeEventingConfigSource eventingConfigSource, String propertyName, String propertyValue) {
        Assertions.assertThat((Collection)eventingConfigSource.getPropertyNames()).contains((Object[])new String[]{propertyName});
        Assertions.assertThat((String)eventingConfigSource.getValue(propertyName)).isEqualTo(propertyValue);
    }
}

