/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.addons.quarkus.knative.eventing;

import io.smallrye.config.ConfigSourceContext;
import io.smallrye.config.ConfigSourceFactory;
import java.util.List;
import java.util.Map;
import java.util.OptionalInt;
import java.util.TreeMap;
import org.eclipse.microprofile.config.spi.ConfigSource;
import org.kie.kogito.addons.quarkus.knative.eventing.KnativeEventingConfigSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class KnativeEventingConfigSourceFactory
implements ConfigSourceFactory {
    public static final String INCLUDE_PROCESS_EVENTS = "org.kie.kogito.addons.quarkus.knative.eventing.includeProcessEvents";
    public static final String SKIP_DEFAULT_INCOMING_STREAM = "org.kie.kogito.addons.quarkus.knative.eventing.skipDefaultIncomingStream";
    private static final String PROCESS_INSTANCES_EVENTS = "kogito-processinstances-events";
    private static final String USER_TASK_INSTANCES_EVENTS = "kogito-usertaskinstances-events";
    private static final String VARIABLE_EVENTS = "kogito-variables-events";
    private static final String QUARKUS_HTTP_CONNECTOR = "quarkus-http";
    private static final String OUTGOING_CONNECTOR_PREFIX = "mp.messaging.outgoing";
    private static final String INCOMING_CONNECTOR_PREFIX = "mp.messaging.incoming";
    private static final String DEFAULT_SINK_URL = "http://localhost:9090";
    private static final String DEFAULT_SINK_URL_EXPRESSION = "${K_SINK:http://localhost:9090}";
    private static final Logger LOGGER = LoggerFactory.getLogger(KnativeEventingConfigSourceFactory.class);

    public Iterable<ConfigSource> getConfigSources(ConfigSourceContext context) {
        String sinkUrl;
        TreeMap<String, String> configuration = new TreeMap<String, String>();
        KnativeEventingConfigSourceFactory.addOutgoingConnector(configuration, "kogito_outgoing_stream");
        if (!this.skipDefaultIncomingStream(context)) {
            KnativeEventingConfigSourceFactory.addIncomingConnector(configuration);
        }
        if (this.includeProcessEvents(context)) {
            KnativeEventingConfigSourceFactory.addOutgoingConnector(configuration, PROCESS_INSTANCES_EVENTS);
            KnativeEventingConfigSourceFactory.addOutgoingConnector(configuration, USER_TASK_INSTANCES_EVENTS);
            KnativeEventingConfigSourceFactory.addOutgoingConnector(configuration, VARIABLE_EVENTS);
        }
        if ((sinkUrl = context.getValue("K_SINK").getValue()) == null || "".equals(sinkUrl)) {
            LOGGER.warn("{} variable is empty or doesn't exist. Please make sure that this service is a Knative Source or has a SinkBinding bound to it.", (Object)"K_SINK");
        }
        configuration.forEach((key, value) -> LOGGER.debug("Adding connector -> {} =  {}", key, value));
        return List.of(new KnativeEventingConfigSource(configuration));
    }

    public OptionalInt getPriority() {
        return OptionalInt.of(KnativeEventingConfigSource.ORDINAL);
    }

    private static void addOutgoingConnector(Map<String, String> configuration, String name) {
        configuration.put(KnativeEventingConfigSourceFactory.buildOutgoingConnector(name), QUARKUS_HTTP_CONNECTOR);
        configuration.put(KnativeEventingConfigSourceFactory.buildOutgoingConnectorUrl(name), DEFAULT_SINK_URL_EXPRESSION);
    }

    private static void addIncomingConnector(Map<String, String> configuration) {
        configuration.put("mp.messaging.incoming.kogito_incoming_stream.connector", QUARKUS_HTTP_CONNECTOR);
        configuration.put("mp.messaging.incoming.kogito_incoming_stream.path", "/");
    }

    private static String buildOutgoingConnector(String name) {
        return "mp.messaging.outgoing." + name + ".connector";
    }

    private static String buildOutgoingConnectorUrl(String name) {
        return "mp.messaging.outgoing." + name + ".url";
    }

    private boolean includeProcessEvents(ConfigSourceContext context) {
        return Boolean.parseBoolean(context.getValue(INCLUDE_PROCESS_EVENTS).getValue());
    }

    private boolean skipDefaultIncomingStream(ConfigSourceContext context) {
        return Boolean.parseBoolean(context.getValue(SKIP_DEFAULT_INCOMING_STREAM).getValue());
    }
}

