/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.addons.quarkus.knative.eventing;

import io.smallrye.config.ConfigSourceContext;
import io.smallrye.config.ConfigSourceFactory;
import java.util.HashMap;
import java.util.List;
import java.util.OptionalInt;
import org.eclipse.microprofile.config.spi.ConfigSource;
import org.kie.kogito.addons.quarkus.knative.eventing.KnativeEventingConfigSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class KnativeEventingConfigSourceFactory
implements ConfigSourceFactory {
    private static final String URL_CONFIG = "mp.messaging.outgoing.kogito_outgoing_stream.url";
    private static final String DEFAULT_SINK_URL = "http://localhost:9090";
    private static final Logger LOGGER = LoggerFactory.getLogger(KnativeEventingConfigSourceFactory.class);

    public Iterable<ConfigSource> getConfigSources(ConfigSourceContext context) {
        HashMap<String, String> configuration = new HashMap<String, String>();
        configuration.put("mp.messaging.outgoing.kogito_outgoing_stream.connector", "quarkus-http");
        configuration.put(URL_CONFIG, "${K_SINK:http://localhost:9090}");
        String sinkUrl = context.getValue("K_SINK").getValue();
        if (sinkUrl == null || "".equals(sinkUrl)) {
            LOGGER.warn("{} variable is empty or doesn't exist. Please make sure that this service is a Knative Source or has a SinkBinding bound to it.", (Object)"K_SINK");
        }
        return List.of(new KnativeEventingConfigSource(configuration));
    }

    public OptionalInt getPriority() {
        return OptionalInt.of(KnativeEventingConfigSource.ORDINAL);
    }
}

