/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.addons.quarkus.knative.eventing;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.eclipse.microprofile.config.ConfigProvider;
import org.eclipse.microprofile.config.spi.ConfigSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KnativeEventingConfigSource
implements ConfigSource {
    private static final Map<String, String> configuration = new HashMap<String, String>();
    private static final String URL_CONFIG = "mp.messaging.outgoing.kogito_outgoing_stream.url";
    private static final String DEFAULT_SINK_URL = "http://localhost:9090";
    public static final String K_SINK = "K_SINK";
    private static final Logger LOGGER = LoggerFactory.getLogger(KnativeEventingConfigSource.class);

    public int getOrdinal() {
        return 99;
    }

    public Set<String> getPropertyNames() {
        return configuration.keySet();
    }

    public String getValue(String propertyName) {
        Optional sinkUrl;
        if (URL_CONFIG.equals(propertyName) && ((sinkUrl = ConfigProvider.getConfig().getOptionalValue(K_SINK, String.class)).isEmpty() || "".equals(sinkUrl.get()))) {
            LOGGER.warn("{} variable is empty or don't exist. Please make sure that this service is a Knative Source or has a SinkBinding bound to it.", (Object)K_SINK);
        }
        return configuration.get(propertyName);
    }

    public String getName() {
        return KnativeEventingConfigSource.class.getSimpleName();
    }

    static {
        configuration.put("mp.messaging.outgoing.kogito_outgoing_stream.connector", "quarkus-http");
        configuration.put(URL_CONFIG, "${K_SINK:http://localhost:9090}");
    }
}

