/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.jobs.service.repository.infinispan;

import io.quarkus.runtime.StartupEvent;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.Optional;
import javax.enterprise.event.Event;
import javax.enterprise.inject.Instance;
import org.apache.commons.io.IOUtils;
import org.assertj.core.api.Assertions;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.client.hotrod.RemoteCacheManagerAdmin;
import org.infinispan.commons.configuration.BasicConfiguration;
import org.infinispan.commons.configuration.XMLStringConfiguration;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.kie.kogito.jobs.service.repository.infinispan.InfinispanConfiguration;
import org.kie.kogito.jobs.service.repository.infinispan.InfinispanInitialized;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;

@ExtendWith(value={MockitoExtension.class})
class InfinispanConfigurationTest {
    private InfinispanConfiguration tested;

    InfinispanConfigurationTest() {
    }

    @BeforeEach
    public void setUp() {
        this.tested = new InfinispanConfiguration();
    }

    @Test
    void initializeCaches(@Mock Event<InfinispanInitialized> initializedEvent, @Mock RemoteCacheManager remoteCacheManager, @Mock Instance<RemoteCacheManager> instance, @Mock RemoteCacheManagerAdmin administration, @Mock RemoteCache<Object, Object> cache) throws IOException {
        Mockito.when((Object)((RemoteCacheManager)instance.get())).thenReturn((Object)remoteCacheManager);
        Mockito.when((Object)remoteCacheManager.administration()).thenReturn((Object)administration);
        Mockito.when((Object)administration.getOrCreateCache(ArgumentMatchers.anyString(), (BasicConfiguration)ArgumentMatchers.any(XMLStringConfiguration.class))).thenReturn(cache);
        ArgumentCaptor templateCaptor = ArgumentCaptor.forClass(XMLStringConfiguration.class);
        Assertions.assertThat((Boolean)this.tested.isInitialized()).isFalse();
        this.tested.initializeCaches(new StartupEvent(), Optional.of("infinispan"), instance, initializedEvent);
        ((RemoteCacheManagerAdmin)Mockito.verify((Object)administration)).getOrCreateCache((String)ArgumentMatchers.eq((Object)"JOB_DETAILS"), (BasicConfiguration)templateCaptor.capture());
        Assertions.assertThat((String)((XMLStringConfiguration)templateCaptor.getValue()).toXMLString(null)).isEqualTo(IOUtils.toString((InputStream)this.getClass().getClassLoader().getResourceAsStream("META-INF/kogito-cache-default.xml"), (Charset)Charset.forName("UTF-8")));
        ((Event)Mockito.verify(initializedEvent)).fire((Object)((InfinispanInitialized)ArgumentMatchers.any(InfinispanInitialized.class)));
        Assertions.assertThat((Boolean)this.tested.isInitialized()).isTrue();
    }
}

