/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.manager;

import java.security.AccessController;
import java.util.List;
import java.util.stream.Collectors;
import org.wildfly.security.manager.WildFlySecurityManager;

final class JDKSpecific {
    private static final int OFFSET = 2;

    JDKSpecific() {
    }

    public static Class<?> getCallerClass(int n) {
        StackWalker stackWalker = WildFlySecurityManager.isChecking() ? AccessController.doPrivileged(JDKSpecific::getStackWalker) : JDKSpecific.getStackWalker();
        List frames = stackWalker.walk(s -> s.limit(n + 2).collect(Collectors.toList()));
        return ((StackWalker.StackFrame)frames.get(frames.size() - 1)).getDeclaringClass();
    }

    private static StackWalker getStackWalker() {
        return StackWalker.getInstance(StackWalker.Option.RETAIN_CLASS_REFERENCE);
    }
}

