/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.jobs.service.stream;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Optional;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.eclipse.microprofile.config.inject.ConfigProperty;
import org.eclipse.microprofile.reactive.messaging.Acknowledgment;
import org.eclipse.microprofile.reactive.messaging.Channel;
import org.eclipse.microprofile.reactive.messaging.Emitter;
import org.eclipse.microprofile.reactive.messaging.Incoming;
import org.eclipse.microprofile.reactive.messaging.OnOverflow;
import org.kie.kogito.jobs.service.events.JobDataEvent;
import org.kie.kogito.jobs.service.model.job.JobDetails;
import org.kie.kogito.jobs.service.model.job.ScheduledJobAdapter;
import org.kie.kogito.jobs.service.utils.FunctionsUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
public class KafkaJobStreams {
    private static final Logger LOGGER = LoggerFactory.getLogger(KafkaJobStreams.class);
    public static final String PUBLISH_EVENTS_CONFIG_KEY = "kogito.jobs-service.events-support";
    private ObjectMapper objectMapper;
    private Emitter<String> kafkaEmitter;
    private Optional<Boolean> enabled;
    private String url;

    public KafkaJobStreams() {
    }

    @Inject
    public KafkaJobStreams(ObjectMapper objectMapper, @ConfigProperty(name="kogito.jobs-service.events-support") Optional<String> config, @Channel(value="kogito-job-service-job-status-events") @OnOverflow(value=OnOverflow.Strategy.LATEST) Emitter<String> emitter, @ConfigProperty(name="kogito.service.url", defaultValue="http://localhost:8080") String url) {
        this.objectMapper = objectMapper;
        this.enabled = config.map(Boolean::valueOf).filter(Boolean.TRUE::equals);
        this.kafkaEmitter = emitter;
        this.url = url;
    }

    @Incoming(value="job-status-change-events")
    @Acknowledgment(value=Acknowledgment.Strategy.PRE_PROCESSING)
    public void jobStatusChangeKafkaPublisher(JobDetails job) {
        this.enabled.map(e -> this.kafkaEmitter).map(emitter -> {
            JobDataEvent event = JobDataEvent.builder().source(this.url + "/jobs").data(ScheduledJobAdapter.of(job)).build();
            return emitter.send(FunctionsUtil.unchecked(this.objectMapper::writeValueAsString).apply(event));
        }).ifPresent(emitter -> LOGGER.debug("Job Status change published to kafka {}", (Object)job));
    }
}

