/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.jobs.service.repository.impl;

import io.quarkus.arc.DefaultBean;
import java.time.ZonedDateTime;
import java.util.Optional;
import java.util.concurrent.CompletionStage;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Any;
import javax.enterprise.inject.Instance;
import javax.inject.Inject;
import org.eclipse.microprofile.config.inject.ConfigProperty;
import org.eclipse.microprofile.reactive.streams.operators.PublisherBuilder;
import org.kie.kogito.jobs.service.model.JobStatus;
import org.kie.kogito.jobs.service.model.job.JobDetails;
import org.kie.kogito.jobs.service.qualifier.Repository;
import org.kie.kogito.jobs.service.repository.ReactiveJobRepository;
import org.kie.kogito.jobs.service.repository.impl.BaseReactiveJobRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@DefaultBean
@ApplicationScoped
public class JobRepositoryDelegate
implements ReactiveJobRepository {
    private static final Logger LOGGER = LoggerFactory.getLogger(JobRepositoryDelegate.class);
    private ReactiveJobRepository delegate;

    JobRepositoryDelegate() {
    }

    @Inject
    public JobRepositoryDelegate(@Any Instance<ReactiveJobRepository> instances, @ConfigProperty(name="kogito.jobs-service.persistence") Optional<String> persistence) {
        this.delegate = (ReactiveJobRepository)instances.select(BaseReactiveJobRepository.class, new Repository.Literal(persistence.orElse("in-memory"))).get();
        LOGGER.info("JobRepository selected {}", (Object)this.delegate.getClass());
    }

    @Override
    public CompletionStage<JobDetails> save(JobDetails job) {
        return this.delegate.save(job);
    }

    @Override
    public CompletionStage<JobDetails> get(String id) {
        return this.delegate.get(id);
    }

    @Override
    public CompletionStage<Boolean> exists(String id) {
        return this.delegate.exists(id);
    }

    @Override
    public CompletionStage<JobDetails> delete(String id) {
        return this.delegate.delete(id);
    }

    @Override
    public CompletionStage<JobDetails> delete(JobDetails job) {
        return this.delegate.delete(job);
    }

    @Override
    public PublisherBuilder<JobDetails> findByStatus(JobStatus ... status) {
        return this.delegate.findByStatus(status);
    }

    @Override
    public PublisherBuilder<JobDetails> findAll() {
        return this.delegate.findAll();
    }

    @Override
    public PublisherBuilder<JobDetails> findByStatusBetweenDatesOrderByPriority(ZonedDateTime from, ZonedDateTime to, JobStatus ... status) {
        return this.delegate.findByStatusBetweenDatesOrderByPriority(from, to, status);
    }

    @Override
    public CompletionStage<JobDetails> merge(String id, JobDetails job) {
        return this.delegate.merge(id, job);
    }
}

