/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.jobs.service.model;

import java.time.ZonedDateTime;
import java.util.Objects;
import java.util.StringJoiner;

public class JobExecutionResponse {
    private String message;
    private String code;
    private ZonedDateTime timestamp;
    private String jobId;

    public JobExecutionResponse() {
    }

    public JobExecutionResponse(String message, String code, ZonedDateTime timestamp, String jobId) {
        this.message = message;
        this.code = code;
        this.timestamp = timestamp;
        this.jobId = jobId;
    }

    public String getMessage() {
        return this.message;
    }

    public String getCode() {
        return this.code;
    }

    public ZonedDateTime getTimestamp() {
        return this.timestamp;
    }

    public String getJobId() {
        return this.jobId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof JobExecutionResponse)) {
            return false;
        }
        JobExecutionResponse that = (JobExecutionResponse)o;
        return Objects.equals(this.getMessage(), that.getMessage()) && Objects.equals(this.getCode(), that.getCode()) && Objects.equals(this.getTimestamp(), that.getTimestamp()) && Objects.equals(this.getJobId(), that.getJobId());
    }

    public int hashCode() {
        return Objects.hash(this.getMessage(), this.getCode(), this.getTimestamp(), this.getJobId());
    }

    public String toString() {
        return new StringJoiner(", ", JobExecutionResponse.class.getSimpleName() + "[", "]").add("message='" + this.message + "'").add("code='" + this.code + "'").add("timestamp=" + this.timestamp).add("jobId='" + this.jobId + "'").toString();
    }

    public static JobExecutionResponseBuilder builder() {
        return new JobExecutionResponseBuilder();
    }

    public static class JobExecutionResponseBuilder {
        private String message;
        private String code;
        private ZonedDateTime timestamp;
        private String jobId;

        public JobExecutionResponseBuilder message(String message) {
            this.message = message;
            return this;
        }

        public JobExecutionResponseBuilder code(String code) {
            this.code = code;
            return this;
        }

        public JobExecutionResponseBuilder timestamp(ZonedDateTime timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        public JobExecutionResponseBuilder now() {
            this.timestamp = ZonedDateTime.now();
            return this;
        }

        public JobExecutionResponseBuilder jobId(String jobId) {
            this.jobId = jobId;
            return this;
        }

        public JobExecutionResponse build() {
            return new JobExecutionResponse(this.message, this.code, this.timestamp, this.jobId);
        }
    }
}

