/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.core.interception.jaxrs;

import java.io.IOException;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.net.URI;
import java.util.Date;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import javax.ws.rs.container.ContainerResponseFilter;
import javax.ws.rs.core.EntityTag;
import javax.ws.rs.core.Link;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.NewCookie;
import javax.ws.rs.core.Response;
import org.jboss.resteasy.core.ResteasyContext;
import org.jboss.resteasy.core.ServerResponseWriter;
import org.jboss.resteasy.core.SynchronousDispatcher;
import org.jboss.resteasy.core.interception.jaxrs.ResponseContainerRequestContext;
import org.jboss.resteasy.core.interception.jaxrs.SuspendableContainerResponseContext;
import org.jboss.resteasy.resteasy_jaxrs.i18n.LogMessages;
import org.jboss.resteasy.specimpl.BuiltResponse;
import org.jboss.resteasy.spi.ApplicationException;
import org.jboss.resteasy.spi.Dispatcher;
import org.jboss.resteasy.spi.HttpRequest;
import org.jboss.resteasy.spi.HttpResponse;
import org.jboss.resteasy.spi.ResteasyAsynchronousResponse;
import org.jboss.resteasy.tracing.RESTEasyTracingLogger;

public class ContainerResponseContextImpl
implements SuspendableContainerResponseContext {
    protected final HttpRequest request;
    protected final HttpResponse httpResponse;
    protected final BuiltResponse jaxrsResponse;
    private ResponseContainerRequestContext requestContext;
    private ContainerResponseFilter[] responseFilters;
    private ServerResponseWriter.RunnableWithIOException continuation;
    private int currentFilter;
    private boolean suspended;
    private boolean filterReturnIsMeaningful = true;
    private Map<Class<?>, Object> contextDataMap;
    private boolean inFilter;
    private Throwable throwable;
    private Consumer<Throwable> onComplete;
    private boolean weSuspended;

    @Deprecated
    public ContainerResponseContextImpl(HttpRequest request, HttpResponse httpResponse, BuiltResponse serverResponse) {
        this(request, httpResponse, serverResponse, null, new ContainerResponseFilter[0], t -> {}, null);
    }

    public ContainerResponseContextImpl(HttpRequest request, HttpResponse httpResponse, BuiltResponse serverResponse, ResponseContainerRequestContext requestContext, ContainerResponseFilter[] responseFilters, Consumer<Throwable> onComplete, ServerResponseWriter.RunnableWithIOException continuation) {
        this.request = request;
        this.httpResponse = httpResponse;
        this.jaxrsResponse = serverResponse;
        this.requestContext = requestContext;
        this.responseFilters = responseFilters;
        this.continuation = continuation;
        this.onComplete = onComplete;
        this.contextDataMap = ResteasyContext.getContextDataMap();
    }

    public BuiltResponse getJaxrsResponse() {
        return this.jaxrsResponse;
    }

    public HttpResponse getHttpResponse() {
        return this.httpResponse;
    }

    @Override
    public int getStatus() {
        return this.jaxrsResponse.getStatus();
    }

    @Override
    public void setStatus(int code) {
        this.httpResponse.setStatus(code);
        this.jaxrsResponse.setStatus(code);
    }

    @Override
    public Response.StatusType getStatusInfo() {
        return this.jaxrsResponse.getStatusInfo();
    }

    @Override
    public void setStatusInfo(Response.StatusType statusInfo) {
        this.httpResponse.setStatus(statusInfo.getStatusCode());
        this.jaxrsResponse.setStatus(statusInfo.getStatusCode());
    }

    @Override
    public Class<?> getEntityClass() {
        return this.jaxrsResponse.getEntityClass();
    }

    @Override
    public Type getEntityType() {
        return this.jaxrsResponse.getGenericType();
    }

    @Override
    public void setEntity(Object entity) {
        this.jaxrsResponse.setEntity(entity);
        this.getHeaders().remove("Content-Length");
    }

    @Override
    public void setEntity(Object entity, Annotation[] annotations, MediaType mediaType) {
        this.jaxrsResponse.setEntity(entity);
        this.jaxrsResponse.setAnnotations(annotations);
        this.jaxrsResponse.getHeaders().putSingle("Content-Type", mediaType);
        this.getHeaders().remove("Content-Length");
    }

    @Override
    public MultivaluedMap<String, Object> getHeaders() {
        return this.jaxrsResponse.getMetadata();
    }

    @Override
    public Set<String> getAllowedMethods() {
        return this.jaxrsResponse.getAllowedMethods();
    }

    @Override
    public Date getDate() {
        return this.jaxrsResponse.getDate();
    }

    @Override
    public Locale getLanguage() {
        return this.jaxrsResponse.getLanguage();
    }

    @Override
    public int getLength() {
        return this.jaxrsResponse.getLength();
    }

    @Override
    public MediaType getMediaType() {
        return this.jaxrsResponse.getMediaType();
    }

    @Override
    public Map<String, NewCookie> getCookies() {
        return this.jaxrsResponse.getCookies();
    }

    @Override
    public EntityTag getEntityTag() {
        return this.jaxrsResponse.getEntityTag();
    }

    @Override
    public Date getLastModified() {
        return this.jaxrsResponse.getLastModified();
    }

    @Override
    public URI getLocation() {
        return this.jaxrsResponse.getLocation();
    }

    @Override
    public Set<Link> getLinks() {
        return this.jaxrsResponse.getLinks();
    }

    @Override
    public boolean hasLink(String relation) {
        return this.jaxrsResponse.hasLink(relation);
    }

    @Override
    public Link getLink(String relation) {
        return this.jaxrsResponse.getLink(relation);
    }

    @Override
    public Link.Builder getLinkBuilder(String relation) {
        return this.jaxrsResponse.getLinkBuilder(relation);
    }

    @Override
    public boolean hasEntity() {
        return !this.jaxrsResponse.isClosed() && this.jaxrsResponse.hasEntity();
    }

    @Override
    public Object getEntity() {
        return !this.jaxrsResponse.isClosed() ? this.jaxrsResponse.getEntity() : null;
    }

    @Override
    public OutputStream getEntityStream() {
        try {
            return this.httpResponse.getOutputStream();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void setEntityStream(OutputStream entityStream) {
        this.httpResponse.setOutputStream(entityStream);
    }

    @Override
    public Annotation[] getEntityAnnotations() {
        return this.jaxrsResponse.getAnnotations();
    }

    @Override
    public MultivaluedMap<String, String> getStringHeaders() {
        return this.jaxrsResponse.getStringHeaders();
    }

    @Override
    public String getHeaderString(String name) {
        return this.jaxrsResponse.getHeaderString(name);
    }

    @Override
    public synchronized void suspend() {
        if (this.continuation == null) {
            throw new RuntimeException("Suspend not supported yet");
        }
        this.suspended = true;
    }

    @Override
    public synchronized void resume() {
        if (!this.suspended) {
            throw new RuntimeException("Cannot resume: not suspended");
        }
        if (this.inFilter) {
            this.suspended = false;
            return;
        }
        try (ResteasyContext.CloseableContext c = ResteasyContext.addCloseableContextDataLevel(this.contextDataMap);){
            this.filter();
        }
        catch (Throwable t) {
            this.writeException(t);
        }
    }

    @Override
    public synchronized void resume(Throwable t) {
        if (!this.suspended) {
            throw new RuntimeException("Cannot resume: not suspended");
        }
        if (this.inFilter) {
            this.throwable = t;
            this.suspended = false;
        } else {
            try (ResteasyContext.CloseableContext c = ResteasyContext.addCloseableContextDataLevel(this.contextDataMap);){
                this.writeException(t);
            }
        }
    }

    private void writeException(Throwable t) {
        HttpResponse httpResponse = (HttpResponse)this.contextDataMap.get(HttpResponse.class);
        SynchronousDispatcher dispatcher = (SynchronousDispatcher)this.contextDataMap.get(Dispatcher.class);
        ResteasyAsynchronousResponse asyncResponse = this.request.getAsyncContext().getAsyncResponse();
        RESTEasyTracingLogger tracingLogger = RESTEasyTracingLogger.getInstance(this.request);
        tracingLogger.flush(httpResponse.getOutputHeaders());
        dispatcher.unhandledAsynchronousException(httpResponse, t);
        this.onComplete.accept(t);
        asyncResponse.complete();
        asyncResponse.completionCallbacks(t);
    }

    public synchronized void filter() throws IOException {
        RESTEasyTracingLogger logger2 = RESTEasyTracingLogger.getInstance(this.request);
        while (this.currentFilter < this.responseFilters.length) {
            ContainerResponseFilter filter = this.responseFilters[this.currentFilter++];
            try {
                this.suspended = false;
                this.throwable = null;
                this.inFilter = true;
                long timestamp = logger2.timestamp("RESPONSE_FILTER");
                filter.filter(this.requestContext, this);
                logger2.logDuration("RESPONSE_FILTER", timestamp, filter);
            }
            catch (IOException e) {
                throw new ApplicationException(e);
            }
            finally {
                this.inFilter = false;
            }
            if (this.suspended) {
                if (!this.request.getAsyncContext().isSuspended()) {
                    this.request.getAsyncContext().suspend();
                    this.weSuspended = true;
                }
                this.filterReturnIsMeaningful = false;
                return;
            }
            if (this.throwable == null) continue;
            if (this.filterReturnIsMeaningful) {
                SynchronousDispatcher.rethrow(this.throwable);
                continue;
            }
            this.writeException(this.throwable);
            return;
        }
        if (this.continuation == null) {
            return;
        }
        if (this.filterReturnIsMeaningful) {
            this.continuation.run(this.onComplete);
            return;
        }
        try {
            this.continuation.run(t -> {
                this.onComplete.accept((Throwable)t);
                if (this.weSuspended) {
                    this.request.getAsyncContext().complete();
                }
            });
        }
        catch (IOException e) {
            LogMessages.LOGGER.unknownException(this.request.getHttpMethod(), this.request.getUri().getPath(), e);
        }
    }
}

