/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.protostream.impl;

import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import net.jcip.annotations.GuardedBy;
import org.infinispan.protostream.BaseMarshaller;
import org.infinispan.protostream.DescriptorParser;
import org.infinispan.protostream.DescriptorParserException;
import org.infinispan.protostream.EnumMarshaller;
import org.infinispan.protostream.FileDescriptorSource;
import org.infinispan.protostream.MessageMarshaller;
import org.infinispan.protostream.RawProtobufMarshaller;
import org.infinispan.protostream.SerializationContext;
import org.infinispan.protostream.config.Configuration;
import org.infinispan.protostream.descriptors.Descriptor;
import org.infinispan.protostream.descriptors.EnumDescriptor;
import org.infinispan.protostream.descriptors.EnumValueDescriptor;
import org.infinispan.protostream.descriptors.FileDescriptor;
import org.infinispan.protostream.descriptors.GenericDescriptor;
import org.infinispan.protostream.descriptors.ResolutionContext;
import org.infinispan.protostream.impl.BaseMarshallerDelegate;
import org.infinispan.protostream.impl.EnumMarshallerDelegate;
import org.infinispan.protostream.impl.Log;
import org.infinispan.protostream.impl.MessageMarshallerDelegate;
import org.infinispan.protostream.impl.RawProtobufMarshallerDelegate;
import org.infinispan.protostream.impl.parser.SquareProtoParser;

public final class SerializationContextImpl
implements SerializationContext {
    private static final Log log = Log.LogFactory.getLog(SerializationContextImpl.class);
    private final ReentrantReadWriteLock readWriteLock = new ReentrantReadWriteLock();
    private final Lock readLock = this.readWriteLock.readLock();
    private final Lock writeLock = this.readWriteLock.writeLock();
    private final Configuration configuration;
    private final DescriptorParser parser;
    private final Map<String, FileDescriptor> fileDescriptors = new LinkedHashMap<String, FileDescriptor>();
    private final Map<Integer, GenericDescriptor> typeIds = new HashMap<Integer, GenericDescriptor>();
    private final Map<String, GenericDescriptor> genericDescriptors = new HashMap<String, GenericDescriptor>();
    private final Map<String, EnumValueDescriptor> enumValueDescriptors = new HashMap<String, EnumValueDescriptor>();
    private final Map<String, BaseMarshallerDelegate<?>> marshallersByName = new ConcurrentHashMap();
    private final Map<Class<?>, BaseMarshallerDelegate<?>> marshallersByClass = new ConcurrentHashMap();
    private final Map<SerializationContext.MarshallerProvider, SerializationContext.MarshallerProvider> marshallerProviders = new ConcurrentHashMap<SerializationContext.MarshallerProvider, SerializationContext.MarshallerProvider>();

    public SerializationContextImpl(Configuration configuration) {
        if (configuration == null) {
            throw new IllegalArgumentException("configuration cannot be null");
        }
        this.configuration = configuration;
        this.parser = new SquareProtoParser(configuration);
    }

    @Override
    public Configuration getConfiguration() {
        return this.configuration;
    }

    @Override
    public Map<String, FileDescriptor> getFileDescriptors() {
        this.readLock.lock();
        try {
            Map<String, FileDescriptor> map = Collections.unmodifiableMap(new HashMap<String, FileDescriptor>(this.fileDescriptors));
            return map;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public Map<String, GenericDescriptor> getGenericDescriptors() {
        this.readLock.lock();
        try {
            Map<String, GenericDescriptor> map = Collections.unmodifiableMap(new HashMap<String, GenericDescriptor>(this.genericDescriptors));
            return map;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerProtoFiles(FileDescriptorSource source) throws DescriptorParserException {
        if (log.isDebugEnabled()) {
            log.debugf("Registering proto files : %s", (Object)source.getFileDescriptors().keySet());
        }
        Map<String, FileDescriptor> fileDescriptorMap = this.parser.parse(source);
        this.writeLock.lock();
        try {
            for (String fileName : fileDescriptorMap.keySet()) {
                FileDescriptor oldFileDescriptor = this.fileDescriptors.get(fileName);
                if (oldFileDescriptor == null) continue;
                this.unregisterFileDescriptorTypes(oldFileDescriptor);
            }
            this.fileDescriptors.putAll(fileDescriptorMap);
            ResolutionContext resolutionContext = new ResolutionContext(source.getProgressCallback(), this.fileDescriptors, this.genericDescriptors, this.typeIds, this.enumValueDescriptors);
            resolutionContext.resolve();
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    public void unregisterProtoFile(String fileName) {
        block4: {
            log.debugf("Unregistering proto file : %s", (Object)fileName);
            this.writeLock.lock();
            try {
                FileDescriptor fileDescriptor = this.fileDescriptors.remove(fileName);
                if (fileDescriptor != null) {
                    this.unregisterFileDescriptorTypes(fileDescriptor);
                    break block4;
                }
                throw new IllegalArgumentException("File " + fileName + " does not exist");
            }
            finally {
                this.writeLock.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unregisterProtoFiles(Set<String> fileNames) {
        log.debugf("Unregistering proto files : %s", (Object)fileNames);
        this.writeLock.lock();
        try {
            for (String fileName : fileNames) {
                FileDescriptor fileDescriptor = this.fileDescriptors.remove(fileName);
                if (fileDescriptor != null) {
                    this.unregisterFileDescriptorTypes(fileDescriptor);
                    continue;
                }
                throw new IllegalArgumentException("File " + fileName + " does not exist");
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @GuardedBy(value="writeLock")
    private void unregisterFileDescriptorTypes(FileDescriptor fileDescriptor) {
        if (fileDescriptor.isResolved()) {
            for (GenericDescriptor d : fileDescriptor.getTypes().values()) {
                Integer typeId = d.getTypeId();
                if (typeId != null) {
                    this.typeIds.remove(typeId);
                }
                if (!(d instanceof EnumDescriptor)) continue;
                for (EnumValueDescriptor ev : ((EnumDescriptor)d).getValues()) {
                    this.enumValueDescriptors.remove(ev.getScopedName());
                }
            }
            this.genericDescriptors.keySet().removeAll(fileDescriptor.getTypes().keySet());
            fileDescriptor.markUnresolved();
        }
        for (FileDescriptor fd : fileDescriptor.getDependants().values()) {
            this.unregisterFileDescriptorTypes(fd);
        }
    }

    @Override
    public Descriptor getMessageDescriptor(String fullTypeName) {
        GenericDescriptor descriptor = this.getDescriptorByName(fullTypeName);
        if (!(descriptor instanceof Descriptor)) {
            throw new IllegalArgumentException(fullTypeName + " is not a message type");
        }
        return (Descriptor)descriptor;
    }

    @Override
    public EnumDescriptor getEnumDescriptor(String fullTypeName) {
        GenericDescriptor descriptor = this.getDescriptorByName(fullTypeName);
        if (!(descriptor instanceof EnumDescriptor)) {
            throw new IllegalArgumentException(fullTypeName + " is not an enum type");
        }
        return (EnumDescriptor)descriptor;
    }

    @Override
    public void registerMarshaller(BaseMarshaller<?> marshaller) {
        if (marshaller == null) {
            throw new IllegalArgumentException("marshaller argument cannot be null");
        }
        BaseMarshallerDelegate<?> marshallerDelegate = this.makeMarshallerDelegate(marshaller);
        BaseMarshallerDelegate<?> existingDelegate = this.marshallersByName.put(marshaller.getTypeName(), marshallerDelegate);
        if (existingDelegate != null) {
            this.marshallersByClass.remove(existingDelegate.getMarshaller().getJavaClass());
        }
        if ((existingDelegate = this.marshallersByClass.put(marshaller.getJavaClass(), marshallerDelegate)) != null) {
            this.marshallersByName.remove(existingDelegate.getMarshaller().getTypeName());
        }
    }

    private BaseMarshallerDelegate<?> makeMarshallerDelegate(BaseMarshaller<?> marshaller) {
        if (marshaller.getJavaClass().isEnum() && !(marshaller instanceof EnumMarshaller)) {
            throw new IllegalArgumentException("Invalid marshaller (the produced class is a Java Enum but the marshaller is not an EnumMarshaller) : " + marshaller.getClass().getName());
        }
        if (marshaller instanceof EnumMarshaller) {
            if (!marshaller.getJavaClass().isEnum()) {
                throw new IllegalArgumentException("Invalid enum marshaller (the produced class is not a Java Enum) : " + marshaller.getClass().getName());
            }
            EnumDescriptor enumDescriptor = this.getEnumDescriptor(marshaller.getTypeName());
            return new EnumMarshallerDelegate((EnumMarshaller)marshaller, enumDescriptor);
        }
        if (marshaller instanceof RawProtobufMarshaller) {
            return new RawProtobufMarshallerDelegate(this, (RawProtobufMarshaller)marshaller);
        }
        Descriptor messageDescriptor = this.getMessageDescriptor(marshaller.getTypeName());
        return new MessageMarshallerDelegate(this, (MessageMarshaller)marshaller, messageDescriptor);
    }

    @Override
    public void unregisterMarshaller(BaseMarshaller<?> marshaller) {
        if (marshaller == null) {
            throw new IllegalArgumentException("marshaller argument cannot be null");
        }
        BaseMarshallerDelegate<?> marshallerDelegate = this.marshallersByName.get(marshaller.getTypeName());
        if (marshallerDelegate == null || marshallerDelegate.getMarshaller() != marshaller) {
            throw new IllegalArgumentException("The given marshaller was not previously registered with this SerializationContext");
        }
        this.marshallersByName.remove(marshaller.getTypeName());
        this.marshallersByClass.remove(marshaller.getJavaClass());
    }

    @Override
    public void registerMarshallerProvider(SerializationContext.MarshallerProvider marshallerProvider) {
        if (marshallerProvider == null) {
            throw new IllegalArgumentException("marshallerProvider argument cannot be null");
        }
        this.marshallerProviders.put(marshallerProvider, marshallerProvider);
    }

    @Override
    public void unregisterMarshallerProvider(SerializationContext.MarshallerProvider marshallerProvider) {
        if (marshallerProvider == null) {
            throw new IllegalArgumentException("marshallerProvider argument cannot be null");
        }
        this.marshallerProviders.remove(marshallerProvider);
    }

    @Override
    public boolean canMarshall(Class<?> javaClass) {
        return this.marshallersByClass.containsKey(javaClass) || this.getMarshallerFromProvider(javaClass) != null;
    }

    @Override
    public boolean canMarshall(String fullTypeName) {
        return this.marshallersByName.containsKey(fullTypeName) || this.getMarshallerFromProvider(fullTypeName) != null;
    }

    @Override
    public <T> BaseMarshaller<T> getMarshaller(String fullTypeName) {
        return this.getMarshallerDelegate(fullTypeName).getMarshaller();
    }

    @Override
    public <T> BaseMarshaller<T> getMarshaller(Class<T> clazz) {
        return this.getMarshallerDelegate(clazz).getMarshaller();
    }

    public <T> BaseMarshallerDelegate<T> getMarshallerDelegate(String descriptorFullName) {
        BaseMarshallerDelegate<?> marshallerDelegate = this.marshallersByName.get(descriptorFullName);
        if (marshallerDelegate == null) {
            BaseMarshaller<?> marshaller = this.getMarshallerFromProvider(descriptorFullName);
            if (marshaller == null) {
                throw new IllegalArgumentException("No marshaller registered for Protobuf type " + descriptorFullName);
            }
            marshallerDelegate = this.makeMarshallerDelegate(marshaller);
        }
        return marshallerDelegate;
    }

    public <T> BaseMarshallerDelegate<T> getMarshallerDelegate(Class<T> javaClass) {
        BaseMarshallerDelegate<?> marshallerDelegate = this.marshallersByClass.get(javaClass);
        if (marshallerDelegate == null) {
            BaseMarshaller<?> marshaller = this.getMarshallerFromProvider(javaClass);
            if (marshaller == null) {
                throw new IllegalArgumentException("No marshaller registered for Java type " + javaClass.getName());
            }
            marshallerDelegate = this.makeMarshallerDelegate(marshaller);
        }
        return marshallerDelegate;
    }

    private BaseMarshaller<?> getMarshallerFromProvider(Class<?> javaClass) {
        if (!this.marshallerProviders.isEmpty()) {
            for (SerializationContext.MarshallerProvider mp : this.marshallerProviders.keySet()) {
                BaseMarshaller<?> marshaller = mp.getMarshaller(javaClass);
                if (marshaller == null) continue;
                return marshaller;
            }
        }
        return null;
    }

    private BaseMarshaller<?> getMarshallerFromProvider(String fullTypeName) {
        if (!this.marshallerProviders.isEmpty()) {
            for (SerializationContext.MarshallerProvider mp : this.marshallerProviders.keySet()) {
                BaseMarshaller<?> marshaller = mp.getMarshaller(fullTypeName);
                if (marshaller == null) continue;
                return marshaller;
            }
        }
        return null;
    }

    @Override
    public String getTypeNameById(Integer typeId) {
        return this.getDescriptorByTypeId(typeId).getFullName();
    }

    @Override
    public Integer getTypeIdByName(String fullTypeName) {
        return this.getDescriptorByName(fullTypeName).getTypeId();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GenericDescriptor getDescriptorByName(String fullTypeName) {
        if (fullTypeName == null) {
            throw new IllegalArgumentException("Type name cannot be null");
        }
        this.readLock.lock();
        try {
            GenericDescriptor descriptor = this.genericDescriptors.get(fullTypeName);
            if (descriptor == null) {
                throw new IllegalArgumentException("Unknown type name : " + fullTypeName);
            }
            GenericDescriptor genericDescriptor = descriptor;
            return genericDescriptor;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GenericDescriptor getDescriptorByTypeId(Integer typeId) {
        if (typeId == null) {
            throw new IllegalArgumentException("Type id cannot be null");
        }
        this.readLock.lock();
        try {
            GenericDescriptor descriptor = this.typeIds.get(typeId);
            if (descriptor == null) {
                throw new IllegalArgumentException("Unknown type id : " + typeId);
            }
            GenericDescriptor genericDescriptor = descriptor;
            return genericDescriptor;
        }
        finally {
            this.readLock.unlock();
        }
    }
}

