/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.impl.transaction.operations;

import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import java.util.concurrent.atomic.AtomicInteger;
import javax.transaction.xa.Xid;
import org.infinispan.client.hotrod.configuration.Configuration;
import org.infinispan.client.hotrod.impl.operations.RetryOnFailureOperation;
import org.infinispan.client.hotrod.impl.protocol.Codec;
import org.infinispan.client.hotrod.impl.transport.netty.ByteBufUtil;
import org.infinispan.client.hotrod.impl.transport.netty.ChannelFactory;
import org.infinispan.client.hotrod.impl.transport.netty.HeaderDecoder;

public class ForgetTransactionOperation
extends RetryOnFailureOperation<Void> {
    private final Xid xid;

    public ForgetTransactionOperation(Codec codec, ChannelFactory channelFactory, AtomicInteger topologyId, Configuration cfg, Xid xid) {
        super((short)121, (short)122, codec, channelFactory, DEFAULT_CACHE_NAME_BYTES, topologyId, 0, cfg, null);
        this.xid = xid;
    }

    @Override
    public void acceptResponse(ByteBuf buf, short status, HeaderDecoder decoder) {
        this.complete(null);
    }

    @Override
    protected void executeOperation(Channel channel) {
        this.scheduleRead(channel);
        ByteBuf buf = channel.alloc().buffer(this.estimateSize());
        this.codec.writeHeader(buf, this.header);
        ByteBufUtil.writeXid(buf, this.xid);
        channel.writeAndFlush(buf);
    }

    private int estimateSize() {
        return this.codec.estimateHeaderSize(this.header) + ByteBufUtil.estimateXidSize(this.xid);
    }
}

