/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.kafka.admin;

import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.kafka.admin.ConfigEntry;
import io.vertx.kafka.admin.ConfigSynonym;
import java.util.ArrayList;
import java.util.Map;
import org.apache.kafka.clients.admin.ConfigEntry;

public class ConfigEntryConverter {
    public static void fromJson(Iterable<Map.Entry<String, Object>> json, ConfigEntry obj) {
        for (Map.Entry<String, Object> member : json) {
            switch (member.getKey()) {
                case "default": {
                    if (!(member.getValue() instanceof Boolean)) break;
                    obj.setDefault((Boolean)member.getValue());
                    break;
                }
                case "name": {
                    if (!(member.getValue() instanceof String)) break;
                    obj.setName((String)member.getValue());
                    break;
                }
                case "readOnly": {
                    if (!(member.getValue() instanceof Boolean)) break;
                    obj.setReadOnly((Boolean)member.getValue());
                    break;
                }
                case "sensitive": {
                    if (!(member.getValue() instanceof Boolean)) break;
                    obj.setSensitive((Boolean)member.getValue());
                    break;
                }
                case "source": {
                    if (!(member.getValue() instanceof String)) break;
                    obj.setSource(ConfigEntry.ConfigSource.valueOf((String)member.getValue()));
                    break;
                }
                case "synonyms": {
                    if (!(member.getValue() instanceof JsonArray)) break;
                    ArrayList<ConfigSynonym> list = new ArrayList<ConfigSynonym>();
                    ((Iterable)member.getValue()).forEach(item -> {
                        if (item instanceof JsonObject) {
                            list.add(new ConfigSynonym((JsonObject)item));
                        }
                    });
                    obj.setSynonyms(list);
                    break;
                }
                case "value": {
                    if (!(member.getValue() instanceof String)) break;
                    obj.setValue((String)member.getValue());
                }
            }
        }
    }

    public static void toJson(ConfigEntry obj, JsonObject json) {
        ConfigEntryConverter.toJson(obj, json.getMap());
    }

    public static void toJson(ConfigEntry obj, Map<String, Object> json) {
        json.put("default", obj.isDefault());
        if (obj.getName() != null) {
            json.put("name", obj.getName());
        }
        json.put("readOnly", obj.isReadOnly());
        json.put("sensitive", obj.isSensitive());
        if (obj.getSource() != null) {
            json.put("source", obj.getSource().name());
        }
        if (obj.getSynonyms() != null) {
            JsonArray array = new JsonArray();
            obj.getSynonyms().forEach(item -> array.add(item.toJson()));
            json.put("synonyms", array);
        }
        if (obj.getValue() != null) {
            json.put("value", obj.getValue());
        }
    }
}

