/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web.client.impl;

import io.netty.handler.codec.http.cookie.Cookie;
import io.vertx.core.http.impl.HttpUtils;
import io.vertx.ext.web.client.spi.CookieStore;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.function.Consumer;

public class CookieStoreImpl
implements CookieStore {
    private ConcurrentHashMap<Key, Cookie> noDomainCookies = new ConcurrentHashMap();
    private ConcurrentSkipListMap<Key, Cookie> domainCookies = new ConcurrentSkipListMap();

    @Override
    public Iterable<Cookie> get(Boolean ssl, String domain, String path) {
        assert (domain != null && domain.length() > 0);
        String uri = HttpUtils.removeDots(path);
        int pos = uri.indexOf(63);
        if (pos > -1) {
            uri = uri.substring(0, pos);
        }
        if ((pos = uri.indexOf(35)) > -1) {
            uri = uri.substring(0, pos);
        }
        String cleanPath = uri;
        TreeMap matches = new TreeMap();
        Consumer<Cookie> adder = c -> {
            if (ssl != Boolean.TRUE && c.isSecure()) {
                return;
            }
            if (c.path() != null && !cleanPath.equals(c.path())) {
                String cookiePath = c.path();
                if (!cookiePath.endsWith("/")) {
                    cookiePath = cookiePath + '/';
                }
                if (!cleanPath.startsWith(cookiePath)) {
                    return;
                }
            }
            matches.put(c.name(), c);
        };
        for (Cookie c2 : this.noDomainCookies.values()) {
            adder.accept(c2);
        }
        Key key = new Key(domain, "", "");
        String prefix = key.domain.substring(0, 1);
        for (Map.Entry entry : this.domainCookies.tailMap((Object)new Key(prefix, "", ""), true).entrySet()) {
            if (((Key)entry.getKey()).domain.compareTo(key.domain) > 0) break;
            if (!key.domain.startsWith(((Key)entry.getKey()).domain)) continue;
            adder.accept((Cookie)entry.getValue());
        }
        return matches.values();
    }

    @Override
    public CookieStore put(Cookie cookie) {
        Key key = new Key(cookie.domain(), cookie.path(), cookie.name());
        if (key.domain.equals("")) {
            this.noDomainCookies.put(key, cookie);
            return this;
        }
        this.domainCookies.put(key, cookie);
        return this;
    }

    @Override
    public CookieStore remove(Cookie cookie) {
        Key key = new Key(cookie.domain(), cookie.path(), cookie.name());
        if (key.domain.equals("")) {
            this.noDomainCookies.remove(key);
        } else {
            this.domainCookies.remove(key);
        }
        return this;
    }

    private static class Key
    implements Comparable<Key> {
        private static final String NO_DOMAIN = "";
        private final String domain;
        private final String path;
        private final String name;

        public Key(String domain, String path, String name) {
            if (domain == null || domain.length() == 0) {
                this.domain = NO_DOMAIN;
            } else {
                while (domain.charAt(0) == '.') {
                    domain = domain.substring(1);
                }
                while (domain.charAt(domain.length() - 1) == '.') {
                    domain = domain.substring(0, domain.length() - 1);
                }
                if (domain.length() == 0) {
                    this.domain = NO_DOMAIN;
                } else {
                    CharSequence[] tokens = domain.split("\\.");
                    int i = 0;
                    int j = tokens.length - 1;
                    while (i < tokens.length / 2) {
                        String tmp = tokens[j];
                        tokens[j] = tokens[i];
                        tokens[i] = tmp;
                        ++i;
                        --j;
                    }
                    this.domain = String.join((CharSequence)".", tokens);
                }
            }
            this.path = path == null ? NO_DOMAIN : path;
            this.name = name;
        }

        @Override
        public int compareTo(Key o) {
            int ret = this.domain.compareTo(o.domain);
            if (ret == 0) {
                ret = this.path.compareTo(o.path);
            }
            if (ret == 0) {
                ret = this.name.compareTo(o.name);
            }
            return ret;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.domain == null ? 0 : this.domain.hashCode());
            result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
            result = 31 * result + (this.path == null ? 0 : this.path.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Key other = (Key)obj;
            if (this.domain == null ? other.domain != null : !this.domain.equals(other.domain)) {
                return false;
            }
            if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
                return false;
            }
            return !(this.path == null ? other.path != null : !this.path.equals(other.path));
        }
    }
}

