/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.reactive.messaging.kafka.impl;

import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.subscription.UniEmitter;
import io.smallrye.reactive.messaging.health.HealthReport;
import io.smallrye.reactive.messaging.kafka.KafkaConnectorOutgoingConfiguration;
import io.smallrye.reactive.messaging.kafka.OutgoingKafkaRecordMetadata;
import io.smallrye.reactive.messaging.kafka.i18n.KafkaLogging;
import io.smallrye.reactive.messaging.kafka.impl.JsonHelper;
import io.smallrye.reactive.messaging.kafka.impl.KafkaAdminHelper;
import io.smallrye.reactive.messaging.kafka.impl.KafkaSenderProcessor;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.kafka.client.producer.KafkaWriteStream;
import io.vertx.mutiny.core.Vertx;
import io.vertx.mutiny.kafka.admin.KafkaAdminClient;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.common.header.Header;
import org.eclipse.microprofile.reactive.messaging.Message;
import org.eclipse.microprofile.reactive.streams.operators.ReactiveStreams;
import org.eclipse.microprofile.reactive.streams.operators.SubscriberBuilder;
import org.reactivestreams.Processor;

public class KafkaSink {
    private final KafkaWriteStream<?, ?> stream;
    private final int partition;
    private final String key;
    private final String topic;
    private final SubscriberBuilder<? extends Message<?>, Void> subscriber;
    private final long retries;
    private final KafkaConnectorOutgoingConfiguration configuration;
    private final KafkaAdminClient admin;
    private final List<Throwable> failures = new ArrayList<Throwable>();
    private final KafkaSenderProcessor processor;

    public KafkaSink(Vertx vertx, KafkaConnectorOutgoingConfiguration config) {
        JsonObject kafkaConfiguration = this.extractProducerConfiguration(config);
        Map<String, Object> kafkaConfigurationMap = kafkaConfiguration.getMap();
        this.stream = KafkaWriteStream.create(vertx.getDelegate(), kafkaConfigurationMap);
        this.stream.exceptionHandler(e -> {
            if (config.getTopic().isPresent()) {
                KafkaLogging.log.unableToWrite(config.getChannel(), config.getTopic().get(), (Throwable)e);
            } else {
                KafkaLogging.log.unableToWrite(config.getChannel(), (Throwable)e);
            }
        });
        this.partition = config.getPartition();
        this.retries = config.getRetries();
        this.key = config.getKey().orElse(null);
        this.topic = config.getTopic().orElseGet(config::getChannel);
        boolean waitForWriteCompletion = config.getWaitForWriteCompletion();
        int maxInflight = config.getMaxInflightMessages();
        if (maxInflight == 5) {
            maxInflight = config.config().getOptionalValue("max.block.ms", Integer.class).orElse(5);
        }
        int inflight = maxInflight;
        this.configuration = config;
        this.admin = KafkaAdminHelper.createAdminClient(this.configuration, vertx, kafkaConfigurationMap);
        this.processor = new KafkaSenderProcessor(inflight, waitForWriteCompletion, this.writeMessageToKafka());
        this.subscriber = ReactiveStreams.builder().via((Processor)this.processor).onError(f -> {
            KafkaLogging.log.unableToDispatch((Throwable)f);
            this.reportFailure((Throwable)f);
        }).ignore();
    }

    private synchronized void reportFailure(Throwable failure) {
        if (this.failures.size() == 10) {
            this.failures.remove(0);
        }
        this.failures.add(failure);
    }

    private Function<Message<?>, Uni<Void>> writeMessageToKafka() {
        return message -> {
            try {
                String actualTopic;
                Optional<OutgoingKafkaRecordMetadata<?>> om = this.getOutgoingKafkaRecordMetadata((Message<?>)message);
                OutgoingKafkaRecordMetadata metadata = om.orElse(null);
                String string = actualTopic = metadata == null || metadata.getTopic() == null ? this.topic : metadata.getTopic();
                if (actualTopic == null) {
                    KafkaLogging.log.ignoringNoTopicSet();
                    return Uni.createFrom().item(() -> null);
                }
                ProducerRecord<?, ?> record = this.getProducerRecord((Message<?>)message, metadata, actualTopic);
                KafkaLogging.log.sendingMessageToTopic((Message)message, actualTopic);
                Uni uni = Uni.createFrom().emitter(e -> this.stream.send(record, ar -> this.handleWriteResult((AsyncResult<?>)ar, (Message<?>)message, record, (UniEmitter<? super Void>)e)));
                if (this.retries > 0L) {
                    uni = uni.onFailure().retry().withBackOff(Duration.ofSeconds(1L), Duration.ofSeconds(20L)).atMost(this.retries);
                }
                return uni.onFailure().recoverWithUni(t -> {
                    KafkaLogging.log.nackingMessage((Message)message, actualTopic, (Throwable)t);
                    return Uni.createFrom().completionStage(message.nack((Throwable)t));
                });
            }
            catch (RuntimeException e2) {
                KafkaLogging.log.unableToSendRecord(e2);
                return Uni.createFrom().failure(e2);
            }
        };
    }

    private void handleWriteResult(AsyncResult<?> ar, Message<?> message, ProducerRecord<?, ?> record, UniEmitter<? super Void> emitter) {
        String actualTopic = record.topic();
        if (ar.succeeded()) {
            KafkaLogging.log.successfullyToTopic(message, actualTopic);
            message.ack().whenComplete((x, f) -> {
                if (f != null) {
                    emitter.fail((Throwable)f);
                } else {
                    emitter.complete(null);
                }
            });
        } else {
            emitter.fail(ar.cause());
        }
    }

    private Optional<OutgoingKafkaRecordMetadata<?>> getOutgoingKafkaRecordMetadata(Message<?> message) {
        return message.getMetadata(OutgoingKafkaRecordMetadata.class).map(x -> x);
    }

    private ProducerRecord<?, ?> getProducerRecord(Message<?> message, OutgoingKafkaRecordMetadata<?> om, String actualTopic) {
        String actualKey;
        int actualPartition = om == null || om.getPartition() <= -1 ? this.partition : om.getPartition();
        String string = actualKey = om == null || om.getKey() == null ? this.key : om.getKey();
        long actualTimestamp = om == null || om.getKey() == null ? -1L : (om.getTimestamp() != null ? om.getTimestamp().toEpochMilli() : -1L);
        List<Header> kafkaHeaders = om == null || om.getHeaders() == null ? Collections.emptyList() : om.getHeaders();
        return new ProducerRecord(actualTopic, actualPartition == -1 ? null : Integer.valueOf(actualPartition), actualTimestamp == -1L ? null : Long.valueOf(actualTimestamp), actualKey, message.getPayload(), kafkaHeaders);
    }

    private JsonObject extractProducerConfiguration(KafkaConnectorOutgoingConfiguration config) {
        JsonObject kafkaConfiguration = JsonHelper.asJsonObject(config.config());
        kafkaConfiguration.put("acks", config.getAcks());
        if (!kafkaConfiguration.containsKey("bootstrap.servers")) {
            KafkaLogging.log.configServers("bootstrap.servers", config.getBootstrapServers());
            kafkaConfiguration.put("bootstrap.servers", config.getBootstrapServers());
        }
        if (!kafkaConfiguration.containsKey("key.serializer")) {
            KafkaLogging.log.keyDeserializerOmitted();
            kafkaConfiguration.put("key.serializer", config.getKeySerializer());
        }
        if (!kafkaConfiguration.containsKey("max.in.flight.requests.per.connection")) {
            kafkaConfiguration.put("max.in.flight.requests.per.connection", config.getMaxInflightMessages());
        }
        kafkaConfiguration.remove("channel-name");
        kafkaConfiguration.remove("topic");
        kafkaConfiguration.remove("connector");
        kafkaConfiguration.remove("partition");
        kafkaConfiguration.remove("key");
        kafkaConfiguration.remove("max-inflight-messages");
        return kafkaConfiguration;
    }

    public SubscriberBuilder<? extends Message<?>, Void> getSink() {
        return this.subscriber;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void isAlive(HealthReport.HealthReportBuilder builder) {
        if (this.configuration.getHealthEnabled().booleanValue()) {
            ArrayList<Throwable> actualFailures;
            KafkaSink kafkaSink = this;
            synchronized (kafkaSink) {
                actualFailures = new ArrayList<Throwable>(this.failures);
            }
            if (!actualFailures.isEmpty()) {
                builder.add(this.configuration.getChannel(), false, actualFailures.stream().map(Throwable::getMessage).collect(Collectors.joining()));
            } else {
                builder.add(this.configuration.getChannel(), true);
            }
        }
    }

    public void isReady(HealthReport.HealthReportBuilder builder) {
        if (this.configuration.getHealthEnabled().booleanValue()) {
            try {
                Set<String> topics = this.admin.listTopics().await().atMost(Duration.ofSeconds(2L));
                if (topics.contains(this.topic)) {
                    builder.add(this.configuration.getChannel(), true);
                } else {
                    builder.add(this.configuration.getChannel(), false, "Unable to find topic " + this.topic);
                }
            }
            catch (Exception failed) {
                builder.add(this.configuration.getChannel(), false, "No response from broker for topic " + this.topic + " : " + failed);
            }
        }
    }

    public void closeQuietly() {
        if (this.processor != null) {
            this.processor.cancel();
        }
        CountDownLatch latch = new CountDownLatch(1);
        try {
            this.stream.close(ar -> {
                if (ar.failed()) {
                    KafkaLogging.log.errorWhileClosingWriteStream(ar.cause());
                }
                latch.countDown();
            });
        }
        catch (Throwable e) {
            KafkaLogging.log.errorWhileClosingWriteStream(e);
            latch.countDown();
        }
        try {
            latch.await();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }
}

