/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.openapi.runtime.io.tag;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import io.smallrye.openapi.api.models.tags.TagImpl;
import io.smallrye.openapi.runtime.io.IoLogging;
import io.smallrye.openapi.runtime.io.JsonUtil;
import io.smallrye.openapi.runtime.io.extension.ExtensionReader;
import io.smallrye.openapi.runtime.io.externaldocs.ExternalDocsReader;
import io.smallrye.openapi.runtime.io.tag.TagConstant;
import io.smallrye.openapi.runtime.util.JandexUtil;
import io.smallrye.openapi.runtime.util.TypeUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.eclipse.microprofile.openapi.models.tags.Tag;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.AnnotationValue;

public class TagReader {
    private TagReader() {
    }

    public static Optional<List<Tag>> readTags(AnnotationValue annotationValue) {
        if (annotationValue != null) {
            IoLogging.log.annotationsArray("@Tag");
            AnnotationInstance[] nestedArray = annotationValue.asNestedArray();
            ArrayList<Tag> tags = new ArrayList<Tag>();
            for (AnnotationInstance tagAnno : nestedArray) {
                if (JandexUtil.isRef(tagAnno)) continue;
                tags.add(TagReader.readTag(tagAnno));
            }
            return Optional.of(tags);
        }
        return Optional.empty();
    }

    public static Optional<List<Tag>> readTags(JsonNode node) {
        if (node != null && node.isArray()) {
            IoLogging.log.jsonArray("Tag");
            ArrayNode nodes = (ArrayNode)node;
            ArrayList<Tag> rval = new ArrayList<Tag>(nodes.size());
            for (JsonNode tagNode : nodes) {
                rval.add(TagReader.readTag(tagNode));
            }
            return Optional.of(rval);
        }
        return Optional.empty();
    }

    public static Tag readTag(AnnotationInstance annotationInstance) {
        Objects.requireNonNull(annotationInstance, "Tag annotation must not be null");
        IoLogging.log.singleAnnotation("@Tag");
        TagImpl tag = new TagImpl();
        tag.setName(JandexUtil.stringValue(annotationInstance, "name"));
        tag.setDescription(JandexUtil.stringValue(annotationInstance, "description"));
        tag.setExternalDocs(ExternalDocsReader.readExternalDocs(annotationInstance.value("externalDocs")));
        return tag;
    }

    private static Tag readTag(JsonNode node) {
        IoLogging.log.singleJsonNode("Tag");
        TagImpl tag = new TagImpl();
        tag.setName(JsonUtil.stringProperty(node, "name"));
        tag.setDescription(JsonUtil.stringProperty(node, "description"));
        tag.setExternalDocs(ExternalDocsReader.readExternalDocs(node.get("externalDocs")));
        ExtensionReader.readExtensions(node, tag);
        return tag;
    }

    public static boolean hasTagAnnotation(AnnotationTarget target) {
        return TypeUtil.hasAnnotation(target, TagConstant.DOTNAME_TAG) || TypeUtil.hasAnnotation(target, TagConstant.DOTNAME_TAGS);
    }

    public static List<AnnotationInstance> getTagAnnotations(AnnotationTarget target) {
        return JandexUtil.getRepeatableAnnotation(target, TagConstant.DOTNAME_TAG, TagConstant.DOTNAME_TAGS);
    }
}

