/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.resteasy.runtime.standalone;

import io.netty.buffer.ByteBuf;
import io.quarkus.resteasy.runtime.standalone.VertxBufferImpl;
import io.quarkus.resteasy.runtime.standalone.VertxOutput;
import io.vertx.core.AsyncResult;
import io.vertx.core.Context;
import io.vertx.core.Handler;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpConnection;
import io.vertx.core.http.HttpServerRequest;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import org.jboss.logging.Logger;

public class VertxBlockingOutput
implements VertxOutput {
    private static final Logger log = Logger.getLogger("io.quarkus.resteasy");
    protected boolean waitingForDrain;
    protected boolean drainHandlerRegistered;
    protected final HttpServerRequest request;
    protected boolean first = true;
    protected Throwable throwable;

    public VertxBlockingOutput(final HttpServerRequest request) {
        this.request = request;
        request.response().exceptionHandler((Handler)new Handler<Throwable>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void handle(Throwable event) {
                VertxBlockingOutput.this.throwable = event;
                log.debugf(event, "IO Exception ", new Object[0]);
                VertxBlockingOutput.this.terminateResponse();
                request.connection().close();
                HttpConnection httpConnection = request.connection();
                synchronized (httpConnection) {
                    if (VertxBlockingOutput.this.waitingForDrain) {
                        request.connection().notify();
                    }
                }
            }
        });
        request.response().endHandler(new Handler<Void>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void handle(Void event) {
                HttpConnection httpConnection = request.connection();
                synchronized (httpConnection) {
                    if (VertxBlockingOutput.this.waitingForDrain) {
                        request.connection().notify();
                    }
                }
                VertxBlockingOutput.this.terminateResponse();
            }
        });
    }

    public void terminateResponse() {
    }

    Buffer createBuffer(ByteBuf data) {
        return new VertxBufferImpl(data);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(ByteBuf data, boolean last) throws IOException {
        if (last && data == null) {
            this.request.response().end();
            return;
        }
        try {
            HttpConnection httpConnection = this.request.connection();
            synchronized (httpConnection) {
                try {
                    this.awaitWriteable();
                    if (last) {
                        this.request.response().end(this.createBuffer(data));
                    } else {
                        this.request.response().write(this.createBuffer(data));
                    }
                }
                catch (Exception e) {
                    if (data != null && data.refCnt() > 0) {
                        data.release();
                    }
                    throw new IOException("Failed to write", e);
                }
            }
        }
        finally {
            if (last) {
                this.terminateResponse();
            }
        }
    }

    @Override
    public CompletionStage<Void> writeNonBlocking(ByteBuf data, boolean last) {
        CompletableFuture<Void> ret = new CompletableFuture<Void>();
        if (last && data == null) {
            this.request.response().end(this.handler(ret));
            return ret;
        }
        Buffer buffer = this.createBuffer(data);
        if (last) {
            this.request.response().end(buffer, this.handler(ret));
        } else {
            this.request.response().write(buffer, this.handler(ret));
        }
        return ret;
    }

    private <T extends Throwable> void rethrow(Throwable x) throws T {
        throw x;
    }

    private Handler<AsyncResult<Void>> handler(CompletableFuture<Void> ret) {
        return res -> {
            if (res.succeeded()) {
                ret.complete(null);
            } else {
                ret.completeExceptionally(res.cause());
            }
        };
    }

    private void awaitWriteable() throws IOException {
        if (this.first) {
            this.first = false;
            return;
        }
        assert (Thread.holdsLock(this.request.connection()));
        while (this.request.response().writeQueueFull()) {
            if (this.throwable != null) {
                throw new IOException(this.throwable);
            }
            if (Context.isOnEventLoopThread()) {
                throw new IOException("Attempting a blocking write on io thread");
            }
            if (this.request.response().closed()) {
                throw new IOException("Connection has been closed");
            }
            if (!this.drainHandlerRegistered) {
                this.drainHandlerRegistered = true;
                Handler<Void> handler = new Handler<Void>(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void handle(Void event) {
                        if (VertxBlockingOutput.this.waitingForDrain) {
                            HttpConnection connection;
                            HttpConnection httpConnection = connection = VertxBlockingOutput.this.request.connection();
                            synchronized (httpConnection) {
                                connection.notifyAll();
                            }
                        }
                    }
                };
                this.request.response().drainHandler((Handler)handler);
                this.request.response().closeHandler(handler);
            }
            try {
                this.waitingForDrain = true;
                this.request.connection().wait();
            }
            catch (InterruptedException e) {
                throw new InterruptedIOException(e.getMessage());
            }
            finally {
                this.waitingForDrain = false;
            }
        }
    }
}

