/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.oidc.runtime;

import io.quarkus.oidc.OIDCException;
import io.quarkus.oidc.OidcTenantConfig;
import io.quarkus.oidc.runtime.BearerAuthenticationMechanism;
import io.quarkus.oidc.runtime.CodeAuthenticationMechanism;
import io.quarkus.oidc.runtime.DefaultTenantConfigResolver;
import io.quarkus.oidc.runtime.TenantConfigContext;
import io.quarkus.security.identity.IdentityProviderManager;
import io.quarkus.security.identity.SecurityIdentity;
import io.quarkus.security.identity.request.AuthenticationRequest;
import io.quarkus.security.identity.request.TokenAuthenticationRequest;
import io.quarkus.vertx.http.runtime.security.ChallengeData;
import io.quarkus.vertx.http.runtime.security.HttpAuthenticationMechanism;
import io.quarkus.vertx.http.runtime.security.HttpCredentialTransport;
import io.smallrye.mutiny.Uni;
import io.vertx.ext.web.RoutingContext;
import java.util.Collections;
import java.util.Set;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;

@ApplicationScoped
public class OidcAuthenticationMechanism
implements HttpAuthenticationMechanism {
    @Inject
    DefaultTenantConfigResolver resolver;
    private BearerAuthenticationMechanism bearerAuth = new BearerAuthenticationMechanism();
    private CodeAuthenticationMechanism codeAuth = new CodeAuthenticationMechanism();

    @Override
    public Uni<SecurityIdentity> authenticate(RoutingContext context, IdentityProviderManager identityProviderManager) {
        TenantConfigContext tenantContext = this.resolve(context);
        if (!tenantContext.oidcConfig.tenantEnabled) {
            return Uni.createFrom().nullItem();
        }
        return this.isWebApp(tenantContext) ? this.codeAuth.authenticate(context, identityProviderManager, this.resolver) : this.bearerAuth.authenticate(context, identityProviderManager, this.resolver);
    }

    @Override
    public Uni<ChallengeData> getChallenge(RoutingContext context) {
        TenantConfigContext tenantContext = this.resolve(context);
        if (!tenantContext.oidcConfig.tenantEnabled) {
            return Uni.createFrom().nullItem();
        }
        return this.isWebApp(tenantContext) ? this.codeAuth.getChallenge(context, this.resolver) : this.bearerAuth.getChallenge(context, this.resolver);
    }

    private TenantConfigContext resolve(RoutingContext context) {
        TenantConfigContext tenantContext = this.resolver.resolve(context, false);
        if (tenantContext == null) {
            throw new OIDCException("Tenant configuration context has not been resolved");
        }
        return tenantContext;
    }

    private boolean isWebApp(TenantConfigContext tenantContext) {
        return OidcTenantConfig.ApplicationType.WEB_APP == tenantContext.oidcConfig.applicationType;
    }

    @Override
    public Set<Class<? extends AuthenticationRequest>> getCredentialTypes() {
        return Collections.singleton(TokenAuthenticationRequest.class);
    }

    @Override
    public HttpCredentialTransport getCredentialTransport() {
        return new HttpCredentialTransport(HttpCredentialTransport.Type.AUTHORIZATION, "bearer");
    }
}

