/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.jobs.service.repository.infinispan.marshaller;

import java.io.IOException;
import java.util.Date;
import java.util.Optional;
import org.infinispan.protostream.MessageMarshaller;
import org.kie.kogito.jobs.service.repository.infinispan.marshaller.BaseMarshaller;
import org.kie.kogito.timer.Trigger;
import org.kie.kogito.timer.impl.IntervalTrigger;
import org.kie.kogito.timer.impl.PointInTimeTrigger;

public class TriggerMarshaller
extends BaseMarshaller<Trigger> {
    public String getTypeName() {
        return this.getPackage() + ".Trigger";
    }

    public Class<? extends Trigger> getJavaClass() {
        return Trigger.class;
    }

    public void writeTo(MessageMarshaller.ProtoStreamWriter writer, Trigger trigger) throws IOException {
        writer.writeString("classType", trigger.getClass().getName());
        Optional.ofNullable(trigger).filter(IntervalTrigger.class::isInstance).map(IntervalTrigger.class::cast).ifPresentOrElse(intervalTrigger -> {
            try {
                writer.writeInstant("startTime", this.toInstant(intervalTrigger.getStartTime()));
                writer.writeInstant("endTime", this.toInstant(intervalTrigger.getEndTime()));
                writer.writeInt("repeatLimit", intervalTrigger.getRepeatLimit());
                writer.writeInt("repeatCount", intervalTrigger.getRepeatCount());
                writer.writeInstant("nextFireTime", this.toInstant(intervalTrigger.getNextFireTime()));
                writer.writeLong("period", intervalTrigger.getPeriod());
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }, () -> Optional.ofNullable(trigger).filter(PointInTimeTrigger.class::isInstance).map(PointInTimeTrigger.class::cast).ifPresent(c -> {
            try {
                writer.writeInstant("nextFireTime", this.toInstant(c.hasNextFireTime()));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }));
    }

    public Trigger readFrom(MessageMarshaller.ProtoStreamReader reader) throws IOException {
        String classType = reader.readString("classType");
        Date startTime = this.fromInstant(reader.readInstant("startTime"));
        Date endTime = this.fromInstant(reader.readInstant("endTime"));
        Integer repeatLimit = reader.readInt("repeatLimit");
        Integer repeatCount = reader.readInt("repeatCount");
        Date nextFireTime = this.fromInstant(reader.readInstant("nextFireTime"));
        Long period = reader.readLong("period");
        return Optional.ofNullable(classType).filter(IntervalTrigger.class.getName()::equals).map(c -> {
            IntervalTrigger intervalTrigger = new IntervalTrigger();
            intervalTrigger.setStartTime(startTime);
            intervalTrigger.setEndTime(endTime);
            intervalTrigger.setRepeatLimit(repeatLimit.intValue());
            intervalTrigger.setRepeatCount(repeatCount.intValue());
            intervalTrigger.setNextFireTime(nextFireTime);
            intervalTrigger.setPeriod(period.longValue());
            return intervalTrigger;
        }).orElseGet(() -> Optional.ofNullable(nextFireTime).map(Date::getTime).map(t -> new PointInTimeTrigger(t.longValue(), null, null)).orElse(null));
    }
}

