/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.jobs.service.scheduler.impl;

import io.vertx.mutiny.core.Vertx;
import java.time.ZonedDateTime;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.assertj.core.api.Assertions;
import org.awaitility.Awaitility;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.kie.kogito.jobs.service.executor.HttpJobExecutor;
import org.kie.kogito.jobs.service.model.job.HttpJob;
import org.kie.kogito.jobs.service.model.job.HttpJobContext;
import org.kie.kogito.jobs.service.model.job.JobDetails;
import org.kie.kogito.jobs.service.model.job.ManageableJobHandle;
import org.kie.kogito.jobs.service.scheduler.impl.VertxTimerServiceScheduler;
import org.kie.kogito.jobs.service.utils.DateUtil;
import org.kie.kogito.timer.Job;
import org.kie.kogito.timer.JobContext;
import org.kie.kogito.timer.Trigger;
import org.kie.kogito.timer.impl.PointInTimeTrigger;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Captor;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.Spy;
import org.mockito.junit.jupiter.MockitoExtension;
import org.mockito.verification.VerificationMode;

@ExtendWith(value={MockitoExtension.class})
class VertxTimerServiceSchedulerTest {
    private VertxTimerServiceScheduler tested;
    private Job job;
    private JobContext context;
    private Trigger trigger;
    private JobDetails jobDetails;
    @Mock
    private HttpJobExecutor executor;
    @Captor
    private ArgumentCaptor<CompletionStage<JobDetails>> jobCaptor;
    @Captor
    private ArgumentCaptor<Long> timeCaptor;
    @Spy
    private Vertx vertx = Vertx.vertx();

    VertxTimerServiceSchedulerTest() {
    }

    @BeforeEach
    public void setUp() {
        this.tested = new VertxTimerServiceScheduler(this.vertx);
    }

    @Test
    void testScheduleJob() {
        ZonedDateTime time = DateUtil.now().plusSeconds(1L);
        ManageableJobHandle handle = this.schedule(time);
        ((Vertx)Mockito.verify((Object)this.vertx)).setTimer(((Long)this.timeCaptor.capture()).longValue(), (Consumer)ArgumentMatchers.any());
        Assertions.assertThat((Long)((Long)this.timeCaptor.getValue())).isGreaterThan(time.toInstant().minusMillis(System.currentTimeMillis()).toEpochMilli());
        Awaitility.given().await().atMost(2L, TimeUnit.SECONDS).untilAsserted(() -> ((HttpJobExecutor)Mockito.verify((Object)this.executor)).execute((CompletionStage)this.jobCaptor.capture()));
        Assertions.assertThat((Object)((CompletionStage)this.jobCaptor.getValue()).toCompletableFuture().getNow(null)).isEqualTo((Object)this.jobDetails);
        Assertions.assertThat((boolean)handle.isCancel()).isFalse();
        Assertions.assertThat((ZonedDateTime)handle.getScheduledTime()).isNotNull();
    }

    @Test
    void testRemoveScheduleJob() {
        ManageableJobHandle handle = this.schedule(DateUtil.now().plusHours(1L));
        ((Vertx)Mockito.verify((Object)this.vertx)).setTimer(((Long)this.timeCaptor.capture()).longValue(), (Consumer)ArgumentMatchers.any());
        Awaitility.given().await().atMost(1L, TimeUnit.SECONDS).untilAsserted(() -> {
            Assertions.assertThat((boolean)handle.isCancel()).isFalse();
            Assertions.assertThat((ZonedDateTime)handle.getScheduledTime()).isNotNull();
        });
        Assertions.assertThat((boolean)this.tested.removeJob(handle)).isTrue();
    }

    private ManageableJobHandle schedule(ZonedDateTime time) {
        long timestamp = time.toInstant().toEpochMilli();
        this.trigger = new PointInTimeTrigger(timestamp, null, null);
        this.jobDetails = JobDetails.builder().build();
        this.context = new HttpJobContext(this.jobDetails);
        this.job = new HttpJob(this.executor);
        return this.tested.scheduleJob(this.job, this.context, this.trigger);
    }

    @Test
    void testLifeCycle() {
        Assertions.assertThat((long)System.currentTimeMillis()).isLessThanOrEqualTo(this.tested.getCurrentTime()).isLessThanOrEqualTo(System.currentTimeMillis());
        Assertions.assertThat((long)this.tested.getTimeToNextJob()).isZero();
        Assertions.assertThat((Iterable)this.tested.getTimerJobInstances(0L)).isEmpty();
        this.tested.reset();
        ((Vertx)Mockito.verify((Object)this.vertx, (VerificationMode)Mockito.never())).close();
        this.tested.shutdown();
        ((Vertx)Mockito.verify((Object)this.vertx)).close();
    }
}

