/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.auth.client;

import java.security.GeneralSecurityException;
import java.security.Provider;
import java.util.Map;
import java.util.function.Supplier;
import javax.xml.stream.Location;
import org.wildfly.client.config.ConfigXMLParseException;
import org.wildfly.client.config.XMLLocation;
import org.wildfly.common.Assert;
import org.wildfly.common.function.ExceptionSupplier;
import org.wildfly.security.auth.client.ElytronMessages;
import org.wildfly.security.credential.source.CredentialSource;
import org.wildfly.security.credential.store.CredentialStore;
import org.wildfly.security.credential.store.impl.KeyStoreCredentialStore;

final class CredentialStoreFactory
implements ExceptionSupplier<CredentialStore, ConfigXMLParseException> {
    private final String name;
    private final String type;
    private final Map<String, String> attributes;
    private final XMLLocation location;
    private final ExceptionSupplier<CredentialSource, ConfigXMLParseException> credentialSource;
    private final String providerName;
    private final Supplier<Provider[]> providers;

    CredentialStoreFactory(String name, String type, Map<String, String> attributes, String providerName, XMLLocation location, ExceptionSupplier<CredentialSource, ConfigXMLParseException> supplier, Supplier<Provider[]> providers) {
        this.name = Assert.checkNotNullParam("name", name);
        this.attributes = Assert.checkNotNullParam("attributes", attributes);
        this.type = type == null ? KeyStoreCredentialStore.KEY_STORE_CREDENTIAL_STORE : type;
        this.location = Assert.checkNotNullParam("location", location);
        this.credentialSource = supplier == null ? null : supplier;
        this.providerName = providerName;
        this.providers = providers;
    }

    @Override
    public CredentialStore get() throws ConfigXMLParseException {
        CredentialStore credentialStore;
        try {
            credentialStore = this.providers != null ? (this.providerName != null ? CredentialStore.getInstance(this.type, this.providerName, this.providers) : CredentialStore.getInstance(this.type, this.providers)) : (this.providerName != null ? CredentialStore.getInstance(this.type, this.providerName) : CredentialStore.getInstance(this.type));
            credentialStore.initialize(this.attributes, this.credentialSource == null ? null : new CredentialStore.CredentialSourceProtectionParameter(this.credentialSource.get()));
        }
        catch (GeneralSecurityException e) {
            throw ElytronMessages.xmlLog.xmlFailedToCreateCredentialStore((Location)this.location, e);
        }
        return credentialStore;
    }

    public String getName() {
        return this.name;
    }
}

