/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.jobs.service.utils;

import java.util.function.Function;
import org.eclipse.microprofile.reactive.streams.operators.PublisherBuilder;
import org.eclipse.microprofile.reactive.streams.operators.ReactiveStreams;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ErrorHandling {
    private static final Logger LOGGER = LoggerFactory.getLogger(ErrorHandling.class);

    private ErrorHandling() {
    }

    public static <R, T> Publisher<R> skipErrorPublisher(Function<? super T, Publisher<R>> function, T input) {
        return ReactiveStreams.fromPublisher(function.apply(input)).onError(t -> LOGGER.warn("Error skipped when processing {}.", input, t)).onErrorResumeWithRsPublisher(t -> ReactiveStreams.empty().buildRs()).buildRs();
    }

    public static <R, T> PublisherBuilder<R> skipErrorPublisherBuilder(Function<? super T, PublisherBuilder<R>> function, T input) {
        return function.apply(input).onError(t -> LOGGER.warn("Error skipped when processing {}.", input, t)).onErrorResumeWithRsPublisher(t -> ReactiveStreams.empty().buildRs());
    }
}

