/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.jobs.service.model.job;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.time.ZonedDateTime;
import java.util.Objects;
import java.util.Optional;
import org.kie.kogito.jobs.api.JobBuilder;
import org.kie.kogito.jobs.service.model.ScheduledJob;
import org.kie.kogito.jobs.service.model.job.JobDetails;
import org.kie.kogito.jobs.service.model.job.JobDetailsBuilder;
import org.kie.kogito.jobs.service.model.job.Recipient;
import org.kie.kogito.jobs.service.utils.DateUtil;
import org.kie.kogito.timer.Trigger;
import org.kie.kogito.timer.impl.IntervalTrigger;
import org.kie.kogito.timer.impl.PointInTimeTrigger;

public class ScheduledJobAdapter {
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();

    private ScheduledJobAdapter() {
    }

    public static ScheduledJob of(JobDetails jobDetails) {
        ProcessPayload payload = ScheduledJobAdapter.payloadDeserialize(String.valueOf(jobDetails.getPayload()));
        return ScheduledJob.builder().job(new JobBuilder().id(jobDetails.getId()).priority(jobDetails.getPriority()).expirationTime(Optional.ofNullable(jobDetails.getTrigger()).map(Trigger::hasNextFireTime).map(DateUtil::fromDate).orElse(null)).callbackEndpoint(Optional.ofNullable(jobDetails.getRecipient()).map(Recipient.HTTPRecipient.class::cast).map(Recipient.HTTPRecipient::getEndpoint).orElse(null)).repeatLimit(Optional.ofNullable(jobDetails.getTrigger()).filter(IntervalTrigger.class::isInstance).map(IntervalTrigger.class::cast).map(IntervalTrigger::getRepeatLimit).orElse(null)).repeatInterval(Optional.ofNullable(jobDetails.getTrigger()).filter(IntervalTrigger.class::isInstance).map(IntervalTrigger.class::cast).map(IntervalTrigger::getPeriod).orElse(null)).rootProcessId(payload.getRootProcessId()).rootProcessInstanceId(payload.getRootProcessInstanceId()).processId(payload.getProcessId()).processInstanceId(payload.getProcessInstanceId()).build()).scheduledId(jobDetails.getScheduledId()).status(jobDetails.getStatus()).executionCounter(jobDetails.getExecutionCounter()).retries(jobDetails.getRetries()).lastUpdate(jobDetails.getLastUpdate()).build();
    }

    public static JobDetails to(ScheduledJob scheduledJob) {
        return new JobDetailsBuilder().id(scheduledJob.getId()).correlationId(scheduledJob.getId()).executionCounter(scheduledJob.getExecutionCounter()).lastUpdate(scheduledJob.getLastUpdate()).payload("process").recipient(new Recipient.HTTPRecipient(scheduledJob.getCallbackEndpoint())).retries(scheduledJob.getRetries()).scheduledId(scheduledJob.getScheduledId()).status(scheduledJob.getStatus()).type(JobDetails.Type.HTTP).trigger(ScheduledJobAdapter.triggerAdapter(scheduledJob)).priority(scheduledJob.getPriority()).payload(ScheduledJobAdapter.payloadSerialize(scheduledJob)).build();
    }

    public static Trigger triggerAdapter(ScheduledJob scheduledJob) {
        return Optional.ofNullable(scheduledJob).filter(job -> Objects.nonNull(job.getExpirationTime())).map(job -> job.hasInterval().map(interval -> new IntervalTrigger(0L, DateUtil.toDate(scheduledJob.getExpirationTime()), null, scheduledJob.getRepeatLimit(), 0L, (long)interval, null, null)).orElse(new PointInTimeTrigger(scheduledJob.getExpirationTime().toInstant().toEpochMilli(), null, null))).orElse(null);
    }

    public static IntervalTrigger intervalTrigger(ZonedDateTime start, int repeatLimit, int intervalMillis) {
        return new IntervalTrigger(0L, DateUtil.toDate(start), null, repeatLimit, 0L, intervalMillis, null, null);
    }

    public static String payloadSerialize(ScheduledJob scheduledJob) {
        try {
            return OBJECT_MAPPER.writeValueAsString(new ProcessPayload(scheduledJob.getProcessInstanceId(), scheduledJob.getRootProcessInstanceId(), scheduledJob.getProcessId(), scheduledJob.getRootProcessId()));
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    public static ProcessPayload payloadDeserialize(String payload) {
        try {
            return OBJECT_MAPPER.readValue(payload, ProcessPayload.class);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    static final class ProcessPayload {
        private String processInstanceId;
        private String rootProcessInstanceId;
        private String processId;
        private String rootProcessId;

        private ProcessPayload() {
        }

        public ProcessPayload(String processInstanceId, String rootProcessInstanceId, String processId, String rootProcessId) {
            this.processInstanceId = processInstanceId;
            this.rootProcessInstanceId = rootProcessInstanceId;
            this.processId = processId;
            this.rootProcessId = rootProcessId;
        }

        public String getProcessInstanceId() {
            return this.processInstanceId;
        }

        public String getRootProcessInstanceId() {
            return this.rootProcessInstanceId;
        }

        public String getProcessId() {
            return this.processId;
        }

        public String getRootProcessId() {
            return this.rootProcessId;
        }
    }
}

