/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.protostream.annotations.impl.processor;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.Generated;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.Filer;
import javax.annotation.processing.Messager;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedOptions;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.Name;
import javax.lang.model.element.NestingKind;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.MirroredTypesException;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import javax.tools.Diagnostic;
import org.infinispan.protostream.DescriptorParserException;
import org.infinispan.protostream.ProtobufUtil;
import org.infinispan.protostream.SerializationContext;
import org.infinispan.protostream.SerializationContextInitializer;
import org.infinispan.protostream.WrappedMessage;
import org.infinispan.protostream.annotations.AutoProtoSchemaBuilder;
import org.infinispan.protostream.annotations.ProtoSchemaBuilderException;
import org.infinispan.protostream.annotations.impl.IndentWriter;
import org.infinispan.protostream.annotations.impl.OriginatingClasses;
import org.infinispan.protostream.annotations.impl.processor.AnnotatedClassScanner;
import org.infinispan.protostream.annotations.impl.processor.AnnotationProcessingException;
import org.infinispan.protostream.annotations.impl.processor.CompileTimeProtoSchemaGenerator;
import org.infinispan.protostream.annotations.impl.processor.GeneratedFilesWriter;
import org.infinispan.protostream.annotations.impl.processor.ServiceLoaderFileGenerator;
import org.infinispan.protostream.annotations.impl.processor.types.HasModelElement;
import org.infinispan.protostream.annotations.impl.processor.types.MirrorClassFactory;
import org.infinispan.protostream.annotations.impl.types.XClass;
import org.infinispan.protostream.annotations.impl.types.XMethod;

@SupportedOptions(value={"debug"})
@SupportedAnnotationTypes(value={"org.infinispan.protostream.annotations.AutoProtoSchemaBuilder"})
public final class AutoProtoSchemaBuilderAnnotationProcessor
extends AbstractProcessor {
    public static final String DEBUG_OPTION = "debug";
    static final String ANNOTATION_NAME = "org.infinispan.protostream.annotations.AutoProtoSchemaBuilder";
    private static boolean checkForMinRequiredJava = true;
    private final ServiceLoaderFileGenerator serviceLoaderFileGenerator = new ServiceLoaderFileGenerator(SerializationContextInitializer.class);
    private GeneratedFilesWriter generatedFilesWriter;
    private boolean isDebugEnabled;
    private MirrorClassFactory typeFactory;
    private final Set<String> processedElementsFQN = new HashSet<String>();
    private Types types;
    private Elements elements;
    private Filer filer;
    private Messager messager;

    @Override
    public synchronized void init(ProcessingEnvironment processingEnv) {
        super.init(processingEnv);
        this.isDebugEnabled = processingEnv.getOptions().containsKey(DEBUG_OPTION);
        this.typeFactory = new MirrorClassFactory(processingEnv);
        this.types = processingEnv.getTypeUtils();
        this.elements = processingEnv.getElementUtils();
        this.filer = processingEnv.getFiler();
        this.messager = processingEnv.getMessager();
        this.generatedFilesWriter = new GeneratedFilesWriter(this.filer);
    }

    @Override
    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.latestSupported();
    }

    private void reportError(AnnotationProcessingException ex) {
        if (ex.getLocation() != null) {
            this.messager.printMessage(Diagnostic.Kind.ERROR, ex.getFormattedMessage(), ex.getLocation());
        } else {
            this.messager.printMessage(Diagnostic.Kind.ERROR, ex.getFormattedMessage());
        }
    }

    private void reportError(Element e, String message, Object ... msgParams) {
        String formatted = String.format(message, msgParams);
        if (e != null) {
            this.messager.printMessage(Diagnostic.Kind.ERROR, formatted, e);
        } else {
            this.messager.printMessage(Diagnostic.Kind.ERROR, formatted);
        }
    }

    private void reportWarning(Element e, String message, Object ... msgParams) {
        String formatted = String.format(message, msgParams);
        if (e != null) {
            this.messager.printMessage(Diagnostic.Kind.WARNING, formatted, e);
        } else {
            this.messager.printMessage(Diagnostic.Kind.WARNING, formatted);
        }
    }

    private void logDebug(String message, Object ... msgParams) {
        if (this.isDebugEnabled) {
            this.messager.printMessage(Diagnostic.Kind.NOTE, String.format(message, msgParams));
        }
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        if (this.isDebugEnabled) {
            this.logDebug("AutoProtoSchemaBuilderAnnotationProcessor annotations=%s, rootElements=%s", annotations, roundEnv.getRootElements());
        }
        this.ensureMinRequiredJava();
        Optional<TypeElement> claimedAnnotation = annotations.stream().filter(a -> a.getQualifiedName().contentEquals(ANNOTATION_NAME)).findAny();
        try {
            if (claimedAnnotation.isPresent()) {
                for (Element element : roundEnv.getElementsAnnotatedWith(claimedAnnotation.get())) {
                    AutoProtoSchemaBuilder builderAnnotation = element.getAnnotation(AutoProtoSchemaBuilder.class);
                    SerializationContext serCtx = ProtobufUtil.newSerializationContext();
                    try {
                        this.processElement(roundEnv, serCtx, element, builderAnnotation, new ProcessorContext());
                    }
                    catch (DescriptorParserException | ProtoSchemaBuilderException e) {
                        throw new AnnotationProcessingException(e, element, "%s", AutoProtoSchemaBuilderAnnotationProcessor.getStackTraceAsString(e));
                    }
                }
            }
            if (roundEnv.processingOver()) {
                this.serviceLoaderFileGenerator.writeServiceFile(this.filer);
            }
        }
        catch (AnnotationProcessingException e) {
            if (this.isDebugEnabled) {
                this.logDebug("@AutoProtoSchemaBuilder processor threw an exception: %s", AutoProtoSchemaBuilderAnnotationProcessor.getStackTraceAsString(e));
            }
            this.reportError(e);
        }
        catch (Exception e) {
            this.reportError(null, "@AutoProtoSchemaBuilder processor threw a fatal exception: %s", AutoProtoSchemaBuilderAnnotationProcessor.getStackTraceAsString(e));
        }
        return claimedAnnotation.isPresent();
    }

    private void ensureMinRequiredJava() {
        if (checkForMinRequiredJava && AutoProtoSchemaBuilderAnnotationProcessor.getJavaMajorVersion() < 9) {
            checkForMinRequiredJava = false;
            this.reportWarning(null, "Please ensure you use at least Java ver. 9 for compilation in order to avoid various compiler related bugs from older Java versions that impact the AutoProtoSchemaBuilder annotation processor (you can still set the output target to 8 or above).", new Object[0]);
        }
    }

    private static int getJavaMajorVersion() {
        String[] version = System.getProperty("java.version").split("[.]");
        int major = AutoProtoSchemaBuilderAnnotationProcessor.parseVersionPart(version[0]);
        if (major == 1) {
            major = AutoProtoSchemaBuilderAnnotationProcessor.parseVersionPart(version[1]);
        }
        return major;
    }

    private static int parseVersionPart(String s) {
        Matcher m = Pattern.compile("(\\d+)\\D*").matcher(s);
        return m.find() ? Integer.parseInt(m.group(1)) : 0;
    }

    private static String getStackTraceAsString(Throwable throwable) {
        StringWriter stringWriter = new StringWriter();
        throwable.printStackTrace(new PrintWriter(stringWriter));
        return stringWriter.toString();
    }

    private void processElement(RoundEnvironment roundEnv, SerializationContext serCtx, Element annotatedElement, AutoProtoSchemaBuilder annotation, ProcessorContext processorContext) throws IOException {
        if (annotatedElement.getKind() != ElementKind.PACKAGE && annotatedElement.getKind() != ElementKind.INTERFACE && annotatedElement.getKind() != ElementKind.CLASS) {
            throw new AnnotationProcessingException(annotatedElement, "@AutoProtoSchemaBuilder annotation can only be applied to classes, interfaces and packages.", new Object[0]);
        }
        AnnotatedClassScanner classScanner = new AnnotatedClassScanner(this.messager, this.elements, annotatedElement, annotation);
        classScanner.discoverClasses(roundEnv);
        this.logDebug("AnnotatedClassScanner.discoverClasses returned: %s", classScanner.getClasses());
        if (classScanner.getClasses().isEmpty()) {
            this.reportWarning(annotatedElement, "No ProtoStream annotated classes found matching the criteria. Please review the 'includeClasses' / 'basePackages' attribute of the @AutoProtoSchemaBuilder annotation.", new Object[0]);
        }
        if (annotatedElement.getKind() == ElementKind.PACKAGE) {
            this.processPackage(roundEnv, serCtx, (PackageElement)annotatedElement, annotation, classScanner, processorContext);
        } else {
            this.processClass(roundEnv, serCtx, (TypeElement)annotatedElement, annotation, classScanner, processorContext);
        }
    }

    private void processPackage(RoundEnvironment roundEnv, SerializationContext serCtx, PackageElement packageElement, AutoProtoSchemaBuilder builderAnnotation, AnnotatedClassScanner classScanner, ProcessorContext processorContext) throws IOException {
        String initializerClassName = builderAnnotation.className();
        if (initializerClassName.isEmpty()) {
            throw new AnnotationProcessingException(packageElement, "@AutoProtoSchemaBuilder.className is required when annotating a package.", new Object[0]);
        }
        if (!SourceVersion.isIdentifier(initializerClassName) || SourceVersion.isKeyword(initializerClassName)) {
            throw new AnnotationProcessingException(packageElement, "@AutoProtoSchemaBuilder.className annotation attribute must be a valid Java identifier and must not be fully qualified.", new Object[0]);
        }
        String initializerPackageName = packageElement.isUnnamed() ? null : packageElement.getQualifiedName().toString();
        String initializerFQN = initializerPackageName != null ? initializerPackageName + '.' + initializerClassName : initializerClassName;
        String protobufPackageName = builderAnnotation.schemaPackageName().isEmpty() ? null : builderAnnotation.schemaPackageName();
        String protobufFileName = builderAnnotation.schemaFileName().isEmpty() ? packageElement.getSimpleName() + ".proto" : builderAnnotation.schemaFileName();
        ProcessorContext dependencies = this.processDependencies(roundEnv, serCtx, packageElement, builderAnnotation);
        Set xclasses = classScanner.getClasses().stream().map(this.typeFactory::fromTypeMirror).collect(Collectors.toCollection(LinkedHashSet::new));
        CompileTimeProtoSchemaGenerator protoSchemaGenerator = new CompileTimeProtoSchemaGenerator(this.typeFactory, this.generatedFilesWriter, serCtx, initializerPackageName, protobufFileName, protobufPackageName, dependencies.marshalledClasses, xclasses, builderAnnotation.autoImportClasses(), classScanner);
        String schemaSrc = protoSchemaGenerator.generateAndRegister();
        this.writeSerializationContextInitializer(packageElement, packageElement.getQualifiedName().toString(), builderAnnotation, dependencies.initializerClassNames, classScanner.getClasses(), protoSchemaGenerator.getGeneratedMarshallerClasses(), initializerPackageName, initializerClassName, initializerFQN, protobufFileName, protobufPackageName, schemaSrc);
        processorContext.add(classScanner.getInitializerFQClassName(), protobufFileName, protoSchemaGenerator.getMarshalledClasses());
    }

    private void processClass(RoundEnvironment roundEnv, SerializationContext serCtx, TypeElement typeElement, AutoProtoSchemaBuilder builderAnnotation, AnnotatedClassScanner classScanner, ProcessorContext processorContext) throws IOException {
        if (typeElement.getNestingKind() == NestingKind.LOCAL || typeElement.getNestingKind() == NestingKind.ANONYMOUS) {
            throw new AnnotationProcessingException(typeElement, "Classes or interfaces annotated with @AutoProtoSchemaBuilder must not be local or anonymous.", new Object[0]);
        }
        if (typeElement.getNestingKind() == NestingKind.MEMBER && !typeElement.getModifiers().contains((Object)Modifier.STATIC)) {
            throw new AnnotationProcessingException(typeElement, "Nested classes or interfaces annotated with @AutoProtoSchemaBuilder must be static.", new Object[0]);
        }
        if (typeElement.getModifiers().contains((Object)Modifier.FINAL)) {
            throw new AnnotationProcessingException(typeElement, "Classes annotated with @AutoProtoSchemaBuilder must not be final.", new Object[0]);
        }
        if (!(builderAnnotation.className().isEmpty() || SourceVersion.isIdentifier(builderAnnotation.className()) && !SourceVersion.isKeyword(builderAnnotation.className()))) {
            throw new AnnotationProcessingException(typeElement, "@AutoProtoSchemaBuilder.className annotation attribute must be a valid Java identifier and must not be fully qualified.", new Object[0]);
        }
        TypeMirror serializationContextInitializerTypeMirror = this.elements.getTypeElement(SerializationContextInitializer.class.getName()).asType();
        if (!this.types.isSubtype(typeElement.asType(), serializationContextInitializerTypeMirror)) {
            throw new AnnotationProcessingException(typeElement, "Classes or interfaces annotated with @AutoProtoSchemaBuilder must implement/extend %s", SerializationContextInitializer.class.getName());
        }
        PackageElement packageElement = this.elements.getPackageOf(typeElement);
        String initializerPackageName = packageElement.isUnnamed() ? null : packageElement.getQualifiedName().toString();
        String initializerClassName = classScanner.getInitializerClassName();
        String initializerFQN = classScanner.getInitializerFQClassName();
        String protobufPackageName = builderAnnotation.schemaPackageName().isEmpty() ? null : builderAnnotation.schemaPackageName();
        String protobufFileName = builderAnnotation.schemaFileName().isEmpty() ? typeElement.getSimpleName() + ".proto" : builderAnnotation.schemaFileName();
        ProcessorContext dependencies = this.processDependencies(roundEnv, serCtx, typeElement, builderAnnotation);
        this.warnOverrideExistingMethods(typeElement);
        Set xclasses = classScanner.getClasses().stream().map(this.typeFactory::fromTypeMirror).collect(Collectors.toCollection(LinkedHashSet::new));
        CompileTimeProtoSchemaGenerator protoSchemaGenerator = new CompileTimeProtoSchemaGenerator(this.typeFactory, this.generatedFilesWriter, serCtx, typeElement.getQualifiedName().toString(), protobufFileName, protobufPackageName, dependencies.marshalledClasses, xclasses, builderAnnotation.autoImportClasses(), classScanner);
        String schemaSrc = protoSchemaGenerator.generateAndRegister();
        this.writeSerializationContextInitializer(typeElement, typeElement.getQualifiedName().toString(), builderAnnotation, dependencies.initializerClassNames, classScanner.getClasses(), protoSchemaGenerator.getGeneratedMarshallerClasses(), initializerPackageName, initializerClassName, initializerFQN, protobufFileName, protobufPackageName, schemaSrc);
        processorContext.add(classScanner.getInitializerFQClassName(), protobufFileName, protoSchemaGenerator.getMarshalledClasses());
    }

    private ProcessorContext processDependencies(RoundEnvironment roundEnv, SerializationContext serCtx, Element annotatedElement, AutoProtoSchemaBuilder builderAnnotation) throws IOException {
        List<Object> dependencies = Collections.emptyList();
        try {
            builderAnnotation.dependsOn();
        }
        catch (MirroredTypesException mte) {
            dependencies = mte.getTypeMirrors();
        }
        ProcessorContext processorContext = new ProcessorContext();
        processorContext.marshalledClasses.put(this.typeFactory.fromClass(WrappedMessage.class), "org/infinispan/protostream/message-wrapping.proto");
        for (TypeMirror typeMirror : dependencies) {
            TypeElement dependencyElement = (TypeElement)this.types.asElement(typeMirror);
            String dependencyFQN = dependencyElement.getQualifiedName().toString();
            AutoProtoSchemaBuilder dependencyAnnotation = dependencyElement.getAnnotation(AutoProtoSchemaBuilder.class);
            if (dependencyAnnotation == null) {
                throw new AnnotationProcessingException(annotatedElement, "Dependency %s is not annotated with @AutoProtoSchemaBuilder annotation", dependencyFQN);
            }
            if (!this.processedElementsFQN.add(dependencyFQN)) {
                throw new AnnotationProcessingException(annotatedElement, "Illegal recursive dependency on %s", dependencyFQN);
            }
            boolean wasGenerationEnabled = this.generatedFilesWriter.isEnabled();
            this.generatedFilesWriter.setEnabled(false);
            this.processElement(roundEnv, serCtx, dependencyElement, dependencyAnnotation, processorContext);
            this.generatedFilesWriter.setEnabled(wasGenerationEnabled);
            this.processedElementsFQN.remove(dependencyFQN);
        }
        return processorContext;
    }

    private void warnOverrideExistingMethods(TypeElement typeElement) {
        XClass annotatedType = this.typeFactory.fromTypeMirror(typeElement.asType());
        this.warnOverrideExistingMethod(annotatedType, "getProtoFileName", new XClass[0]);
        this.warnOverrideExistingMethod(annotatedType, "getProtoFile", new XClass[0]);
        XClass serializationContextClass = this.typeFactory.fromClass(SerializationContext.class);
        this.warnOverrideExistingMethod(annotatedType, "registerSchema", serializationContextClass);
        this.warnOverrideExistingMethod(annotatedType, "registerMarshallers", serializationContextClass);
    }

    private void warnOverrideExistingMethod(XClass xclass, String methodName, XClass ... argTypes) {
        XMethod method = xclass.getMethod(methodName, argTypes);
        if (method != null && !method.isAbstract()) {
            this.reportWarning(((HasModelElement)((Object)method)).getElement(), "Code generated by @AutoProtoSchemaBuilder processor will override your %s.%s method.", method.getDeclaringClass().getName(), method.getName());
        }
    }

    private void writeSerializationContextInitializer(Element annotatedElement, String annotatedElementFQN, AutoProtoSchemaBuilder annotation, Set<String> serCtxInitDeps, Collection<? extends TypeMirror> classes, Set<String> generatedMarshallerClasses, String packageName, String initializerClassName, String initializerFQN, String fileName, String protobufPackageName, String schemaSrc) throws IOException {
        Element[] originatingElements = new Element[classes.size() + 1];
        originatingElements[0] = annotatedElement;
        int i = 1;
        for (TypeMirror typeMirror : classes) {
            originatingElements[i++] = this.types.asElement(typeMirror);
        }
        String schemaResource = annotation.schemaFilePath();
        if (schemaResource.isEmpty()) {
            schemaResource = null;
        } else {
            if (!schemaResource.startsWith("/")) {
                schemaResource = '/' + schemaResource;
            }
            if (!schemaResource.endsWith("/")) {
                schemaResource = schemaResource + '/';
            }
            schemaResource = schemaResource + (fileName.startsWith("/") ? fileName.substring(1) : fileName);
            this.generatedFilesWriter.addSchemaResourceFile(schemaResource, schemaSrc, originatingElements);
        }
        if (annotation.service()) {
            this.serviceLoaderFileGenerator.addProvider(initializerFQN, annotatedElement);
        }
        String string = this.generateSerializationContextInitializer(annotatedElement, annotatedElementFQN, annotation, serCtxInitDeps, classes, generatedMarshallerClasses, packageName, initializerClassName, fileName, protobufPackageName, schemaSrc, schemaResource);
        this.generatedFilesWriter.addInitializerSourceFile(initializerFQN, string, originatingElements);
    }

    private String generateSerializationContextInitializer(Element annotatedElement, String annotatedElementFQN, AutoProtoSchemaBuilder annotation, Set<String> serCtxInitDeps, Collection<? extends TypeMirror> classes, Set<String> generatedMarshallerClasses, String packageName, String initializerClassName, String fileName, String protobufPackageName, String schemaSrc, String schemaResource) {
        int j;
        IndentWriter iw = new IndentWriter();
        iw.append("/*\n");
        iw.append(" Generated by ").append(this.getClass().getName()).append("\n");
        iw.append(annotatedElement.getKind() == ElementKind.PACKAGE ? " for package " : " for class ").append(annotatedElementFQN).append("\n");
        iw.append(" annotated with ").append(String.valueOf(annotation)).append("\n");
        iw.append(" */\n\n");
        if (packageName != null) {
            iw.append("package ").append(packageName).append(";\n\n");
        }
        this.addGeneratedClassHeader(iw, classes);
        AutoProtoSchemaBuilderAnnotationProcessor.addSchemaBuilderAnnotation(iw, initializerClassName, fileName, annotation.schemaFilePath(), protobufPackageName, classes, serCtxInitDeps, annotation.service());
        iw.append("public class ").append(initializerClassName);
        if (annotatedElement.getKind() == ElementKind.PACKAGE) {
            iw.append(" implements ").append(SerializationContextInitializer.class.getName()).append(" {\n\n");
        } else {
            iw.append(annotatedElement.getKind() == ElementKind.INTERFACE ? " implements " : " extends ").append(annotatedElementFQN).append(" {\n\n");
        }
        iw.inc();
        if (schemaResource == null) {
            iw.append("private static final String PROTO_SCHEMA = ").append(this.makeStringLiteral(schemaSrc)).append(";\n\n");
        }
        int k = 0;
        for (String s : serCtxInitDeps) {
            iw.append("private final ").append(s).append(" dep").append(String.valueOf(k++)).append(" = new ").append(s).append("();\n\n");
        }
        iw.append("@Override\npublic String getProtoFileName() { return \"").append(fileName).append("\"; }\n\n");
        iw.append("@Override\npublic String getProtoFile() { return ");
        if (schemaResource == null) {
            iw.append("PROTO_SCHEMA");
        } else {
            iw.append("org.infinispan.protostream.FileDescriptorSource.getResourceAsString(getClass(), \"").append(schemaResource).append("\")");
        }
        iw.append("; }\n\n");
        iw.append("@Override\n");
        iw.append("public void registerSchema(org.infinispan.protostream.SerializationContext serCtx) {\n");
        iw.inc();
        for (j = 0; j < serCtxInitDeps.size(); ++j) {
            iw.append("dep").append(String.valueOf(j)).append(".registerSchema(serCtx);\n");
        }
        iw.append("serCtx.registerProtoFiles(org.infinispan.protostream.FileDescriptorSource.fromString(getProtoFileName(), getProtoFile()));\n");
        iw.dec();
        iw.append("}\n\n");
        iw.append("@Override\n");
        iw.append("public void registerMarshallers(org.infinispan.protostream.SerializationContext serCtx) {\n");
        iw.inc();
        for (j = 0; j < serCtxInitDeps.size(); ++j) {
            iw.append("dep").append(String.valueOf(j)).append(".registerMarshallers(serCtx);\n");
        }
        for (String name : generatedMarshallerClasses) {
            iw.append("serCtx.registerMarshaller(new ").append(name).append("());\n");
        }
        iw.dec();
        iw.append("}\n");
        iw.dec();
        iw.append("}\n");
        return iw.toString();
    }

    static void addGeneratedClassHeader(IndentWriter iw, boolean addPrivateJavadocTag, String ... classes) {
        iw.append("/**\n * WARNING: Generated code! Do not edit!\n").append(addPrivateJavadocTag ? " *\n * @private\n" : "").append(" */\n");
        iw.append('@').append(Generated.class.getName()).append("(\n   value = \"").append(AutoProtoSchemaBuilderAnnotationProcessor.class.getName()).append("\",\n   comments = \"Please do not edit this file!\"\n)\n");
        iw.append('@').append(OriginatingClasses.class.getName()).append("({\n");
        iw.inc();
        for (int i = 0; i < classes.length; ++i) {
            if (i != 0) {
                iw.append(",\n");
            }
            iw.append("\"").append(classes[i]).append("\"");
        }
        iw.append('\n');
        iw.dec();
        iw.append("})\n");
    }

    private void addGeneratedClassHeader(IndentWriter iw, Collection<? extends TypeMirror> classes) {
        String[] names = new String[classes.size()];
        int i = 0;
        for (TypeMirror typeMirror : classes) {
            Name name = ((TypeElement)this.types.asElement(typeMirror)).getQualifiedName();
            names[i++] = name.toString();
        }
        AutoProtoSchemaBuilderAnnotationProcessor.addGeneratedClassHeader(iw, false, names);
    }

    private static void addSchemaBuilderAnnotation(IndentWriter iw, String className, String schemaFileName, String schemaFilePath, String schemaPackageName, Collection<? extends TypeMirror> classes, Set<String> dependsOn, boolean service) {
        boolean first;
        iw.append("/*@").append(ANNOTATION_NAME).append("(\n");
        iw.inc();
        iw.append("className = \"").append(className).append("\",\n");
        iw.append("schemaFileName = \"").append(schemaFileName).append("\",\n");
        if (schemaFilePath != null) {
            iw.append("schemaFilePath = \"").append(schemaFilePath).append("\",\n");
        }
        if (schemaPackageName != null) {
            iw.append("schemaPackageName = \"").append(schemaPackageName).append("\",\n");
        }
        if (!dependsOn.isEmpty()) {
            iw.append("dependsOn = {\n");
            iw.inc();
            first = true;
            for (String string : dependsOn) {
                if (first) {
                    first = false;
                } else {
                    iw.append(',');
                }
                iw.append('\n').append(string).append(".class");
            }
            iw.append('\n');
            iw.dec();
            iw.append("},\n");
        }
        iw.append("service = ").append(String.valueOf(service)).append(",\n");
        iw.append("autoImportClasses = false,\n");
        iw.append("classes = {");
        iw.inc();
        first = true;
        for (TypeMirror typeMirror : classes) {
            if (first) {
                first = false;
            } else {
                iw.append(',');
            }
            iw.append('\n').append(typeMirror.toString()).append(".class");
        }
        iw.append('\n');
        iw.dec();
        iw.append("}\n");
        iw.dec();
        iw.append(")*/\n");
    }

    private String makeStringLiteral(String s) {
        StringBuilder sb = new StringBuilder(s.length() + 2);
        sb.append('\"');
        block5: for (int i = 0; i < s.length(); ++i) {
            char ch = s.charAt(i);
            switch (ch) {
                case '\n': {
                    sb.append("\\n\" +\n\"");
                    continue block5;
                }
                case '\"': {
                    sb.append("\\\"");
                    continue block5;
                }
                case '\\': {
                    sb.append("\\\\");
                    continue block5;
                }
                default: {
                    sb.append(ch);
                }
            }
        }
        sb.append('\"');
        return sb.toString();
    }

    private String makeClassName(TypeElement e) {
        return this.makeNestedClassName(e, e.getSimpleName().toString());
    }

    private String makeNestedClassName(TypeElement e, String className) {
        Element enclosingElement = e.getEnclosingElement();
        if (enclosingElement instanceof PackageElement) {
            PackageElement packageElement = (PackageElement)enclosingElement;
            return packageElement.isUnnamed() ? className : packageElement.getQualifiedName() + "." + className;
        }
        TypeElement typeElement = (TypeElement)enclosingElement;
        return this.makeNestedClassName(typeElement, typeElement.getSimpleName() + "$" + className);
    }

    private static final class ProcessorContext {
        final Set<String> initializerClassNames = new LinkedHashSet<String>();
        final Map<XClass, String> marshalledClasses = new HashMap<XClass, String>();

        private ProcessorContext() {
        }

        void add(String initializerFQN, String protobufFileName, Set<XClass> classes) {
            this.initializerClassNames.add(initializerFQN);
            for (XClass c : classes) {
                this.marshalledClasses.put(c, protobufFileName);
            }
        }
    }
}

