/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.protostream;

import java.util.BitSet;
import org.infinispan.protostream.descriptors.Descriptor;

public class MessageContext<E extends MessageContext> {
    private final E parentContext;
    private final String fieldName;
    private String fullFieldName;
    private final Descriptor messageDescriptor;
    private final BitSet seenFields;
    private int maxSeenFieldNumber = 0;

    public MessageContext(E parentContext, String fieldName, Descriptor messageDescriptor) {
        if (messageDescriptor == null) {
            throw new IllegalArgumentException("messageDescriptor cannot be null");
        }
        if (parentContext != null && fieldName == null) {
            throw new IllegalArgumentException("fieldName cannot be null for nested contexts");
        }
        if (parentContext == null && fieldName != null) {
            throw new IllegalArgumentException("fieldName must be null for root contexts");
        }
        this.parentContext = parentContext;
        this.fieldName = fieldName;
        this.messageDescriptor = messageDescriptor;
        this.seenFields = new BitSet(messageDescriptor.getFields().size() + messageDescriptor.getOneOfs().size());
    }

    public E getParentContext() {
        return this.parentContext;
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public String getFullFieldName() {
        if (this.fieldName == null) {
            return null;
        }
        if (this.fullFieldName == null) {
            String pfqn = null;
            if (this.parentContext != null) {
                pfqn = ((MessageContext)this.parentContext).getFullFieldName();
            }
            this.fullFieldName = pfqn != null ? pfqn + '.' + this.fieldName : this.fieldName;
        }
        return this.fullFieldName;
    }

    public Descriptor getMessageDescriptor() {
        return this.messageDescriptor;
    }

    public boolean isFieldMarked(int fieldNumber) {
        return this.seenFields.get(fieldNumber);
    }

    public boolean markField(int fieldNumber) {
        if (this.seenFields.get(fieldNumber)) {
            return false;
        }
        this.seenFields.set(fieldNumber);
        if (this.maxSeenFieldNumber < fieldNumber) {
            this.maxSeenFieldNumber = fieldNumber;
        }
        return true;
    }

    public int getMaxSeenFieldNumber() {
        return this.maxSeenFieldNumber;
    }
}

