/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.impl.transaction.entry;

import io.netty.buffer.ByteBuf;
import java.util.concurrent.TimeUnit;
import org.infinispan.client.hotrod.impl.protocol.Codec;
import org.infinispan.client.hotrod.impl.transaction.entry.ControlByte;
import org.infinispan.client.hotrod.impl.transport.netty.ByteBufUtil;

public class Modification {
    private final byte[] key;
    private final byte[] value;
    private final long versionRead;
    private final long lifespan;
    private final long maxIdle;
    private final TimeUnit lifespanTimeUnit;
    private final TimeUnit maxIdleTimeUnit;
    private final byte control;

    Modification(byte[] key, byte[] value, long versionRead, long lifespan, long maxIdle, TimeUnit lifespanTimeUnit, TimeUnit maxIdleTimeUnit, byte control) {
        this.key = key;
        this.value = value;
        this.versionRead = versionRead;
        this.lifespan = lifespan;
        this.maxIdle = maxIdle;
        this.lifespanTimeUnit = lifespanTimeUnit;
        this.maxIdleTimeUnit = maxIdleTimeUnit;
        this.control = control;
    }

    public void writeTo(ByteBuf byteBuf, Codec codec) {
        ByteBufUtil.writeArray(byteBuf, this.key);
        byteBuf.writeByte(this.control);
        if (!ControlByte.NON_EXISTING.hasFlag(this.control) && !ControlByte.NOT_READ.hasFlag(this.control)) {
            byteBuf.writeLong(this.versionRead);
        }
        if (ControlByte.REMOVE_OP.hasFlag(this.control)) {
            return;
        }
        codec.writeExpirationParams(byteBuf, this.lifespan, this.lifespanTimeUnit, this.maxIdle, this.maxIdleTimeUnit);
        ByteBufUtil.writeArray(byteBuf, this.value);
    }

    public int estimateSize(Codec codec) {
        int size = this.key.length + 1;
        if (!ControlByte.NON_EXISTING.hasFlag(this.control) && !ControlByte.NOT_READ.hasFlag(this.control)) {
            size += 8;
        }
        if (!ControlByte.REMOVE_OP.hasFlag(this.control)) {
            size += this.value.length;
            size += codec.estimateExpirationSize(this.lifespan, this.lifespanTimeUnit, this.maxIdle, this.maxIdleTimeUnit);
        }
        return size;
    }

    public byte[] getKey() {
        return this.key;
    }
}

