/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.reactive.streams.operators.core;

import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletionStage;
import java.util.function.BiConsumer;
import java.util.function.BinaryOperator;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import org.eclipse.microprofile.reactive.streams.operators.CompletionRunner;
import org.eclipse.microprofile.reactive.streams.operators.ProcessorBuilder;
import org.eclipse.microprofile.reactive.streams.operators.PublisherBuilder;
import org.eclipse.microprofile.reactive.streams.operators.SubscriberBuilder;
import org.eclipse.microprofile.reactive.streams.operators.core.CompletionRunnerImpl;
import org.eclipse.microprofile.reactive.streams.operators.core.InternalStages;
import org.eclipse.microprofile.reactive.streams.operators.core.ReactiveStreamsEngineResolver;
import org.eclipse.microprofile.reactive.streams.operators.core.ReactiveStreamsGraphBuilder;
import org.eclipse.microprofile.reactive.streams.operators.core.Reductions;
import org.eclipse.microprofile.reactive.streams.operators.core.Stages;
import org.eclipse.microprofile.reactive.streams.operators.spi.ReactiveStreamsEngine;
import org.eclipse.microprofile.reactive.streams.operators.spi.Stage;
import org.reactivestreams.Processor;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;

final class PublisherBuilderImpl<T>
extends ReactiveStreamsGraphBuilder
implements PublisherBuilder<T> {
    PublisherBuilderImpl(Stage stage, ReactiveStreamsGraphBuilder previous) {
        super(stage, previous);
    }

    PublisherBuilderImpl(Stage stage) {
        super(stage, null);
    }

    @Override
    public <R> PublisherBuilder<R> map(Function<? super T, ? extends R> mapper) {
        return this.addStage(new Stages.Map(mapper));
    }

    @Override
    public PublisherBuilder<T> peek(Consumer<? super T> consumer) {
        return this.addStage(new Stages.Peek(consumer));
    }

    @Override
    public PublisherBuilder<T> filter(Predicate<? super T> predicate) {
        return this.addStage(new Stages.Filter(predicate));
    }

    @Override
    public PublisherBuilder<T> distinct() {
        return this.addStage(Stages.Distinct.INSTANCE);
    }

    @Override
    public <S> PublisherBuilder<S> flatMap(Function<? super T, ? extends PublisherBuilder<? extends S>> mapper) {
        return this.addStage(new Stages.FlatMap(mapper.andThen(ReactiveStreamsGraphBuilder::rsBuilderToGraph)));
    }

    @Override
    public <S> PublisherBuilder<S> flatMapRsPublisher(Function<? super T, ? extends Publisher<? extends S>> mapper) {
        return this.addStage(new Stages.FlatMap(mapper.andThen(ReactiveStreamsGraphBuilder::publisherToGraph)));
    }

    @Override
    public <S> PublisherBuilder<S> flatMapCompletionStage(Function<? super T, ? extends CompletionStage<? extends S>> mapper) {
        return this.addStage(new Stages.FlatMapCompletionStage(mapper));
    }

    @Override
    public <S> PublisherBuilder<S> flatMapIterable(Function<? super T, ? extends Iterable<? extends S>> mapper) {
        return this.addStage(new Stages.FlatMapIterable(mapper));
    }

    @Override
    public PublisherBuilder<T> limit(long maxSize) {
        return this.addStage(new Stages.Limit(maxSize));
    }

    @Override
    public PublisherBuilder<T> skip(long n) {
        return this.addStage(new Stages.Skip(n));
    }

    @Override
    public PublisherBuilder<T> takeWhile(Predicate<? super T> predicate) {
        return this.addStage(new Stages.TakeWhile(predicate));
    }

    @Override
    public PublisherBuilder<T> dropWhile(Predicate<? super T> predicate) {
        return this.addStage(new Stages.DropWhile(predicate));
    }

    @Override
    public CompletionRunner<Void> forEach(Consumer<? super T> action) {
        Objects.requireNonNull(action, "Action must not be null");
        return this.collect(Collector.of(() -> null, (n, t) -> action.accept(t), (v1, v2) -> null, v -> null, new Collector.Characteristics[0]));
    }

    @Override
    public CompletionRunner<Void> ignore() {
        return this.forEach((T r) -> {});
    }

    @Override
    public CompletionRunner<Void> cancel() {
        return this.addTerminalStage(Stages.Cancel.INSTANCE);
    }

    @Override
    public CompletionRunner<T> reduce(T identity, BinaryOperator<T> accumulator) {
        return this.addTerminalStage(new Stages.Collect(Reductions.reduce(identity, accumulator)));
    }

    @Override
    public CompletionRunner<Optional<T>> reduce(BinaryOperator<T> accumulator) {
        return this.addTerminalStage(new Stages.Collect(Reductions.reduce(accumulator)));
    }

    @Override
    public CompletionRunner<Optional<T>> findFirst() {
        return this.addTerminalStage(Stages.FindFirst.INSTANCE);
    }

    @Override
    public <R, A> CompletionRunner<R> collect(Collector<? super T, A, R> collector) {
        return this.addTerminalStage(new Stages.Collect(collector));
    }

    @Override
    public <R> CompletionRunner<R> collect(Supplier<R> supplier, BiConsumer<R, ? super T> accumulator) {
        return this.addTerminalStage(new Stages.Collect(Collector.of(supplier, accumulator, (a, b) -> a, new Collector.Characteristics[0])));
    }

    @Override
    public CompletionRunner<List<T>> toList() {
        return this.collect(Collectors.toList());
    }

    @Override
    public CompletionRunner<Void> to(Subscriber<? super T> subscriber) {
        return this.addTerminalStage(new Stages.SubscriberStage(subscriber));
    }

    @Override
    public <R> CompletionRunner<R> to(SubscriberBuilder<? super T, ? extends R> subscriber) {
        Objects.requireNonNull(subscriber, "Subscriber must not be null");
        return this.addTerminalStage(InternalStages.nested(subscriber));
    }

    @Override
    public <R> PublisherBuilder<R> via(ProcessorBuilder<? super T, ? extends R> processor) {
        return this.addStage(InternalStages.nested(processor));
    }

    @Override
    public <R> PublisherBuilder<R> via(Processor<? super T, ? extends R> processor) {
        return this.addStage(new Stages.ProcessorStage(processor));
    }

    @Override
    public PublisherBuilder<T> onError(Consumer<Throwable> errorHandler) {
        return this.addStage(new Stages.OnError(errorHandler));
    }

    @Override
    public PublisherBuilder<T> onErrorResume(Function<Throwable, ? extends T> errorHandler) {
        return this.addStage(new Stages.OnErrorResume(errorHandler));
    }

    @Override
    public PublisherBuilder<T> onErrorResumeWith(Function<Throwable, ? extends PublisherBuilder<? extends T>> errorHandler) {
        return this.addStage(new Stages.OnErrorResumeWith(errorHandler.andThen(ReactiveStreamsGraphBuilder::rsBuilderToGraph)));
    }

    @Override
    public PublisherBuilder<T> onErrorResumeWithRsPublisher(Function<Throwable, ? extends Publisher<? extends T>> errorHandler) {
        return this.addStage(new Stages.OnErrorResumeWith(errorHandler.andThen(ReactiveStreamsGraphBuilder::publisherToGraph)));
    }

    @Override
    public PublisherBuilder<T> onTerminate(Runnable action) {
        return this.addStage(new Stages.OnTerminate(action));
    }

    @Override
    public PublisherBuilder<T> onComplete(Runnable action) {
        return this.addStage(new Stages.OnComplete(action));
    }

    @Override
    public Publisher<T> buildRs() {
        return this.buildRs(ReactiveStreamsEngineResolver.instance());
    }

    @Override
    public Publisher<T> buildRs(ReactiveStreamsEngine engine) {
        Objects.requireNonNull(engine, "Engine must not be null");
        return engine.buildPublisher(this.toGraph());
    }

    private <R> PublisherBuilder<R> addStage(Stage stage) {
        return new PublisherBuilderImpl<T>(stage, this);
    }

    private <R> CompletionRunner<R> addTerminalStage(Stage stage) {
        return new CompletionRunnerImpl(stage, this);
    }
}

