/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.jwt;

import io.vertx.ext.jwt.CryptoKeyPair;
import io.vertx.ext.jwt.impl.SignatureHelper;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.X509Certificate;

class CryptoSignature
extends CryptoKeyPair {
    private final Signature sig;
    private final X509Certificate certificate;
    private final boolean ecdsa;

    CryptoSignature(String algorithm, X509Certificate certificate, PrivateKey privateKey) {
        super(algorithm, null, privateKey);
        Signature signature;
        this.certificate = certificate;
        this.ecdsa = this.isECDSA(algorithm);
        try {
            signature = Signature.getInstance(algorithm);
        }
        catch (NoSuchAlgorithmException e) {
            try {
                signature = Signature.getInstance(certificate.getSigAlgName());
            }
            catch (NoSuchAlgorithmException e1) {
                throw new RuntimeException(e);
            }
        }
        this.sig = signature;
    }

    @Override
    public synchronized boolean verify(byte[] signature, byte[] payload) {
        try {
            this.sig.initVerify(this.certificate);
            this.sig.update(payload);
            if (this.ecdsa) {
                return this.sig.verify(SignatureHelper.toDER(signature));
            }
            return this.sig.verify(signature);
        }
        catch (InvalidKeyException | SignatureException e) {
            throw new RuntimeException(e);
        }
    }
}

