/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.logging;

import io.vertx.core.logging.JULLogDelegateFactory;
import io.vertx.core.logging.Logger;
import io.vertx.core.spi.logging.LogDelegate;
import io.vertx.core.spi.logging.LogDelegateFactory;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class LoggerFactory {
    public static final String LOGGER_DELEGATE_FACTORY_CLASS_NAME = "vertx.logger-delegate-factory-class-name";
    private static volatile LogDelegateFactory delegateFactory;
    private static final ConcurrentMap<String, Logger> loggers;

    public static synchronized void initialise() {
        LogDelegateFactory delegateFactory;
        String className = JULLogDelegateFactory.class.getName();
        try {
            className = System.getProperty(LOGGER_DELEGATE_FACTORY_CLASS_NAME);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (className != null) {
            ClassLoader loader = Thread.currentThread().getContextClassLoader();
            try {
                Class<?> clz = loader.loadClass(className);
                delegateFactory = (LogDelegateFactory)clz.newInstance();
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Error instantiating transformer class \"" + className + "\"", e);
            }
        } else {
            delegateFactory = new JULLogDelegateFactory();
        }
        LoggerFactory.delegateFactory = delegateFactory;
    }

    public static Logger getLogger(Class<?> clazz) {
        String name = clazz.isAnonymousClass() ? clazz.getEnclosingClass().getCanonicalName() : clazz.getCanonicalName();
        return LoggerFactory.getLogger(name);
    }

    public static Logger getLogger(String name) {
        LogDelegate delegate;
        Logger oldLogger;
        Logger logger2 = (Logger)loggers.get(name);
        if (logger2 == null && (oldLogger = loggers.putIfAbsent(name, logger2 = new Logger(delegate = delegateFactory.createDelegate(name)))) != null) {
            logger2 = oldLogger;
        }
        return logger2;
    }

    public static void removeLogger(String name) {
        loggers.remove(name);
    }

    static {
        loggers = new ConcurrentHashMap<String, Logger>();
        LoggerFactory.initialise();
    }
}

