/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.http.impl;

import io.netty.buffer.ByteBuf;
import io.netty.channel.AbstractChannel;
import io.netty.channel.Channel;
import io.netty.channel.ChannelConfig;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelId;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelMetadata;
import io.netty.channel.ChannelOutboundBuffer;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.ChannelPromise;
import io.netty.channel.DefaultChannelConfig;
import io.netty.channel.EventLoop;
import io.netty.handler.stream.ChunkedFile;
import io.netty.handler.stream.ChunkedWriteHandler;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import io.vertx.core.Handler;
import io.vertx.core.Promise;
import io.vertx.core.http.impl.VertxHttp2Stream;
import java.io.RandomAccessFile;
import java.net.SocketAddress;

class FileStreamChannel
extends AbstractChannel {
    private static final SocketAddress LOCAL_ADDRESS = new StreamSocketAddress();
    private static final SocketAddress REMOTE_ADDRESS = new StreamSocketAddress();
    private static final ChannelMetadata METADATA = new ChannelMetadata(true);
    private final ChannelConfig config = new DefaultChannelConfig(this);
    private boolean active;
    private boolean closed;
    private long bytesWritten;
    private final VertxHttp2Stream<?> stream;
    final Handler<Void> drainHandler = v -> this.flush();

    FileStreamChannel(final Promise<Long> result, VertxHttp2Stream stream, final long offset, final long length) {
        super(null, Id.INSTANCE);
        this.pipeline().addLast(new ChannelInitializer<Channel>(){

            @Override
            protected void initChannel(Channel ch) throws Exception {
                ChannelPipeline pipeline = ch.pipeline();
                pipeline.addLast(new ChunkedWriteHandler());
                pipeline.addLast(new ChannelInboundHandlerAdapter(){

                    @Override
                    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
                        if (evt instanceof RandomAccessFile) {
                            ChannelFuture fut = ctx.writeAndFlush(new ChunkedFile((RandomAccessFile)evt, offset, length, 8192));
                            fut.addListener((GenericFutureListener<? extends Future<? super Void>>)((GenericFutureListener<Future>)f -> {
                                if (f.isSuccess()) {
                                    result.tryComplete(FileStreamChannel.this.bytesWritten);
                                } else {
                                    result.tryFail(f.cause());
                                }
                                fut.addListener(ChannelFutureListener.CLOSE);
                            }));
                        }
                    }

                    @Override
                    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
                        result.tryFail(cause);
                    }
                });
            }
        });
        this.stream = stream;
    }

    @Override
    protected void doRegister() throws Exception {
        this.active = true;
    }

    @Override
    protected AbstractChannel.AbstractUnsafe newUnsafe() {
        return new DefaultUnsafe();
    }

    @Override
    protected boolean isCompatible(EventLoop loop) {
        return true;
    }

    @Override
    protected SocketAddress localAddress0() {
        return LOCAL_ADDRESS;
    }

    @Override
    protected SocketAddress remoteAddress0() {
        return REMOTE_ADDRESS;
    }

    @Override
    protected void doBind(SocketAddress localAddress) throws Exception {
    }

    @Override
    protected void doDisconnect() throws Exception {
        this.doClose();
    }

    @Override
    protected void doClose() throws Exception {
        this.active = false;
        this.closed = true;
    }

    @Override
    protected void doBeginRead() throws Exception {
    }

    @Override
    protected void doWrite(ChannelOutboundBuffer in) {
        ByteBuf chunk;
        while (!this.stream.isNotWritable() && (chunk = (ByteBuf)in.current()) != null) {
            this.bytesWritten += (long)chunk.readableBytes();
            this.stream.writeData(chunk.retain(), false);
            this.stream.handlerContext.flush();
            in.remove();
        }
    }

    @Override
    public ChannelConfig config() {
        return this.config;
    }

    @Override
    public boolean isOpen() {
        return !this.closed;
    }

    @Override
    public boolean isActive() {
        return this.active;
    }

    @Override
    public ChannelMetadata metadata() {
        return METADATA;
    }

    static class Id
    implements ChannelId {
        static final ChannelId INSTANCE = new Id();

        private Id() {
        }

        @Override
        public String asShortText() {
            return this.toString();
        }

        @Override
        public String asLongText() {
            return this.toString();
        }

        @Override
        public int compareTo(ChannelId o) {
            if (o instanceof Id) {
                return 0;
            }
            return this.asLongText().compareTo(o.asLongText());
        }

        public int hashCode() {
            return 0;
        }

        public boolean equals(Object obj) {
            return obj instanceof Id;
        }

        public String toString() {
            return "stream";
        }
    }

    private class DefaultUnsafe
    extends AbstractChannel.AbstractUnsafe {
        private DefaultUnsafe() {
        }

        @Override
        public void connect(SocketAddress remoteAddress, SocketAddress localAddress, ChannelPromise promise) {
            this.safeSetSuccess(promise);
        }
    }

    private static class StreamSocketAddress
    extends SocketAddress {
        private StreamSocketAddress() {
        }

        public String toString() {
            return "stream";
        }
    }
}

