/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.reactive.messaging.kafka.impl;

import io.smallrye.reactive.messaging.kafka.KafkaConnectorCommonConfiguration;
import io.vertx.mutiny.core.Vertx;
import io.vertx.mutiny.kafka.admin.KafkaAdminClient;
import java.util.HashMap;
import java.util.Map;

public class KafkaAdminHelper {
    private KafkaAdminHelper() {
    }

    public static KafkaAdminClient createAdminClient(KafkaConnectorCommonConfiguration configuration, Vertx vertx, Map<String, Object> kafkaConfigurationMap) {
        if (configuration.getHealthEnabled().booleanValue()) {
            HashMap<String, String> copy = new HashMap<String, String>();
            for (Map.Entry<String, Object> entry : kafkaConfigurationMap.entrySet()) {
                copy.put(entry.getKey(), entry.getValue().toString());
            }
            HashMap<String, String> adminConfiguration = new HashMap<String, String>(copy);
            adminConfiguration.remove("key.serializer");
            adminConfiguration.remove("value.serializer");
            adminConfiguration.remove("key.deserializer");
            adminConfiguration.remove("value.deserializer");
            adminConfiguration.remove("acks");
            adminConfiguration.remove("max.in.flight.requests.per.connection");
            return KafkaAdminClient.create(vertx, adminConfiguration);
        }
        return null;
    }
}

