/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.reactive.messaging.kafka.fault;

import io.smallrye.reactive.messaging.kafka.IncomingKafkaRecord;
import io.smallrye.reactive.messaging.kafka.i18n.KafkaExceptions;
import java.util.concurrent.CompletionStage;

public interface KafkaFailureHandler {
    public <K, V> CompletionStage<Void> handle(IncomingKafkaRecord<K, V> var1, Throwable var2);

    public static enum Strategy {
        FAIL,
        IGNORE,
        DEAD_LETTER_QUEUE;


        public static Strategy from(String s) {
            if (s == null || s.equalsIgnoreCase("fail")) {
                return FAIL;
            }
            if (s.equalsIgnoreCase("ignore")) {
                return IGNORE;
            }
            if (s.equalsIgnoreCase("dead-letter-queue")) {
                return DEAD_LETTER_QUEUE;
            }
            throw KafkaExceptions.ex.illegalArgumentUnknownFailureStrategy(s);
        }
    }
}

