/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.mutiny.vertx;

import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.subscription.UniSubscriber;
import io.smallrye.mutiny.subscription.UniSubscription;
import io.smallrye.mutiny.vertx.AsyncResultUni;
import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;

public class UniHelper {
    public static <T> Uni<T> toUni(Consumer<Handler<AsyncResult<T>>> handler) {
        return AsyncResultUni.toUni(handler);
    }

    public static <T> UniSubscriber<T> toSubscriber(final Handler<AsyncResult<T>> handler) {
        final AtomicBoolean terminated = new AtomicBoolean();
        return new UniSubscriber<T>(){

            @Override
            public void onSubscribe(UniSubscription subscription) {
            }

            @Override
            public void onItem(T item) {
                if (terminated.compareAndSet(false, true)) {
                    handler.handle(Future.succeededFuture(item));
                }
            }

            @Override
            public void onFailure(Throwable failure) {
                if (terminated.compareAndSet(false, true)) {
                    handler.handle(Future.failedFuture(failure));
                }
            }
        };
    }
}

